/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMeta;
import com.cohere.api.types.SummarizeResponseResultsItem;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SummarizeResponse {
    private final Optional<List<SummarizeResponseResultsItem>> results;
    private final Optional<ApiMeta> meta;

    private SummarizeResponse(Optional<List<SummarizeResponseResultsItem>> results, Optional<ApiMeta> meta) {
        this.results = results;
        this.meta = meta;
    }

    @JsonProperty(value="results")
    public Optional<List<SummarizeResponseResultsItem>> getResults() {
        return this.results;
    }

    @JsonProperty(value="meta")
    public Optional<ApiMeta> getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SummarizeResponse && this.equalTo((SummarizeResponse)other);
    }

    private boolean equalTo(SummarizeResponse other) {
        return this.results.equals(other.results) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.results, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<SummarizeResponseResultsItem>> results = Optional.empty();
        private Optional<ApiMeta> meta = Optional.empty();

        private Builder() {
        }

        public Builder from(SummarizeResponse other) {
            this.results(other.getResults());
            this.meta(other.getMeta());
            return this;
        }

        @JsonSetter(value="results", nulls=Nulls.SKIP)
        public Builder results(Optional<List<SummarizeResponseResultsItem>> results) {
            this.results = results;
            return this;
        }

        public Builder results(List<SummarizeResponseResultsItem> results) {
            this.results = Optional.of(results);
            return this;
        }

        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public Builder meta(Optional<ApiMeta> meta) {
            this.meta = meta;
            return this;
        }

        public Builder meta(ApiMeta meta) {
            this.meta = Optional.of(meta);
            return this;
        }

        public SummarizeResponse build() {
            return new SummarizeResponse(this.results, this.meta);
        }
    }
}

