/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SummarizeResponseResultsItem {
    private final Optional<String> id;
    private final Optional<String> summary;

    private SummarizeResponseResultsItem(Optional<String> id, Optional<String> summary) {
        this.id = id;
        this.summary = summary;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="summary")
    public Optional<String> getSummary() {
        return this.summary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SummarizeResponseResultsItem && this.equalTo((SummarizeResponseResultsItem)other);
    }

    private boolean equalTo(SummarizeResponseResultsItem other) {
        return this.id.equals(other.id) && this.summary.equals(other.summary);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.summary);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> summary = Optional.empty();

        private Builder() {
        }

        public Builder from(SummarizeResponseResultsItem other) {
            this.id(other.getId());
            this.summary(other.getSummary());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="summary", nulls=Nulls.SKIP)
        public Builder summary(Optional<String> summary) {
            this.summary = summary;
            return this;
        }

        public Builder summary(String summary) {
            this.summary = Optional.of(summary);
            return this;
        }

        public SummarizeResponseResultsItem build() {
            return new SummarizeResponseResultsItem(this.id, this.summary);
        }
    }
}

