/*
 * Decompiled with CFR 0.152.
 */
package io.github.firemaples.language;

import io.github.firemaples.MicrosoftTranslatorAPI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public enum Language {
    AUTO_DETECT(""),
    AFRIKAANS("af"),
    ARABIC("ar"),
    BANGLA("bn"),
    BOSNIAN("bs"),
    BULGARIAN("bg"),
    CANTONESE_TRADITIONAL("yue"),
    CATALAN("ca"),
    CHINESE_SIMPLIFIED("zh-Hans"),
    CHINESE_TRADITIONAL("zh-Hant"),
    CROATIAN("hr"),
    CZECH("cs"),
    DANISH("da"),
    DUTCH("nl"),
    ENGLISH("en"),
    ESTONIAN("et"),
    FIJIAN("fj"),
    FILIPINO("fil"),
    FINNISH("fi"),
    FRENCH("fr"),
    GERMAN("de"),
    GREEK("el"),
    HAITIAN_CREOLE("ht"),
    HEBREW("he"),
    HINDI("hi"),
    HMONG_DAW("mww"),
    HUNGARIAN("hu"),
    INDONESIAN("id"),
    ITALIAN("it"),
    JAPANESE("ja"),
    KISWAHILI("sw"),
    KLINGON("tlh"),
    KOREAN("ko"),
    LATVIAN("lv"),
    LITHUANIAN("lt"),
    MALAGASY("mg"),
    MALAY("ms"),
    MALTESE("mt"),
    NORWEGIAN("nb"),
    PERSIAN("fa"),
    POLISH("pl"),
    PORTUGUESE("pt"),
    QUER\u00c9TARO_OTOMI("otq"),
    ROMANIAN("ro"),
    RUSSIAN("ru"),
    SAMOAN("sm"),
    SERBIAN_CYRILLIC("sr-Cyrl"),
    SERBIAN_LATIN("sr-Latn"),
    SLOVAK("sk"),
    SLOVENIAN("sl"),
    SPANISH("es"),
    SWEDISH("sv"),
    TAHITIAN("ty"),
    THAI("th"),
    TONGAN("to"),
    TURKISH("tr"),
    UKRAINIAN("uk"),
    URDU("ur"),
    VIETNAMESE("vi"),
    WELSH("cy"),
    YUCATEC_MAYA("yua");

    private final String language;
    private Map<Language, String> localizedCache = new ConcurrentHashMap<Language, String>();

    private Language(String pLanguage) {
        this.language = pLanguage;
    }

    public static Language fromString(String pLanguage) {
        for (Language l : Language.values()) {
            if (!l.toString().equals(pLanguage)) continue;
            return l;
        }
        return null;
    }

    public String toString() {
        return this.language;
    }

    public static void setKey(String pKey) {
        LanguageService.setKey(pKey);
    }

    public static void setSubscriptionKey(String pSubscriptionKey) {
        LanguageService.setSubscriptionKey(pSubscriptionKey);
    }

    public static void resetToken() {
        LanguageService.resetToken();
    }

    public String getName(Language locale) throws Exception {
        String localizedName;
        if (this.localizedCache.containsKey((Object)locale)) {
            localizedName = this.localizedCache.get((Object)locale);
        } else if (this == AUTO_DETECT || locale == AUTO_DETECT) {
            localizedName = "Auto Detect";
        } else {
            String[] names = LanguageService.execute(Language.values(), locale);
            int i = 0;
            for (Language lang : Language.values()) {
                if (lang == AUTO_DETECT) continue;
                lang.localizedCache.put(locale, names[i]);
                ++i;
            }
            localizedName = this.localizedCache.get((Object)locale);
        }
        return localizedName;
    }

    public static List<String> getLanguageCodesForTranslation() throws Exception {
        String[] codes = GetLanguagesForTranslateService.execute();
        return Arrays.asList(codes);
    }

    public static Map<String, Language> values(Language locale) throws Exception {
        TreeMap<String, Language> localizedMap = new TreeMap<String, Language>();
        for (Language lang : Language.values()) {
            if (lang == AUTO_DETECT) {
                localizedMap.put(AUTO_DETECT.name(), lang);
                continue;
            }
            localizedMap.put(lang.getName(locale), lang);
        }
        return localizedMap;
    }

    private void flushCache() {
        this.localizedCache.clear();
    }

    public static void flushNameCache() {
        for (Language lang : Language.values()) {
            lang.flushCache();
        }
    }

    private static final class GetLanguagesForTranslateService
    extends MicrosoftTranslatorAPI {
        private static final String SERVICE_URL = "http://api.microsofttranslator.com/V2/Ajax.svc/GetLanguagesForTranslate?";

        private GetLanguagesForTranslateService() {
        }

        public static String[] execute() throws Exception {
            GetLanguagesForTranslateService.validateServiceState();
            URL url = new URL(SERVICE_URL + (apiKey != null ? "appId=" + URLEncoder.encode(apiKey, "UTF-8") : ""));
            String[] codes = GetLanguagesForTranslateService.retrieveStringArr(url);
            return codes;
        }
    }

    private static final class LanguageService
    extends MicrosoftTranslatorAPI {
        private static final String SERVICE_URL = "api.microsofttranslator.com/V2/Ajax.svc/GetLanguageNames?";

        private LanguageService() {
        }

        public static String[] execute(Language[] targets, Language locale) throws Exception {
            LanguageService.validateServiceState();
            String[] localizedNames = new String[]{};
            if (locale == AUTO_DETECT) {
                return localizedNames;
            }
            String targetString = LanguageService.buildStringArrayParam((Object[])Language.values());
            URL url = new URL(LanguageService.getProtocol() + SERVICE_URL + (apiKey != null ? "appId=" + URLEncoder.encode(apiKey, "UTF-8") : "") + "&locale=" + URLEncoder.encode(locale.toString(), "UTF-8") + "&languageCodes=" + URLEncoder.encode(targetString, "UTF-8"));
            localizedNames = LanguageService.retrieveStringArr(url);
            return localizedNames;
        }
    }
}

