/*
 * Decompiled with CFR 0.152.
 */
package io.github.firemaples;

import io.github.firemaples.utils.JsonUtil;
import io.github.firemaples.utils.TypeReference;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class MicrosoftTranslatorAPI<RQ, RP> {
    protected static final String PROTOCOL_HTTP = "http://";
    protected static final String PROTOCOL_HTTPS = "https://";
    protected static final String HTTP_GET = "GET";
    protected static final String HTTP_POST = "POST";
    protected static final String ENCODING = "UTF-8";
    protected static String protocol = "http://";
    protected static String apiKey;
    private static String DatamarketAccessUri;
    private static String OcpApimSubscriptionKeyHeader;
    private static String referrer;
    private static String subscriptionKey;
    private static String token;
    private static long tokenCacheExpiration;
    private static long tokenExpiration;
    private static String contentType;
    protected static final String PARAM_APP_ID = "appId=";
    protected static final String PARAM_TO_LANG = "&to=";
    protected static final String PARAM_FROM_LANG = "&from=";
    protected static final String PARAM_TEXT_SINGLE = "&text=";
    protected static final String PARAM_TEXT_ARRAY = "&texts=";
    protected static final String PARAM_SPOKEN_LANGUAGE = "&language=";
    protected static final String PARAM_SENTENCES_LANGUAGE = "&language=";
    protected static final String PARAM_LOCALE = "&locale=";
    protected static final String PARAM_LANGUAGE_CODES = "&languageCodes=";
    protected static final String PARAM_SCOPE = "&scope=";
    private JsonUtil<RP> jsonUtil = new JsonUtil();

    public static void setUsingSSL(boolean usingSSL) {
        protocol = usingSSL ? PROTOCOL_HTTPS : PROTOCOL_HTTP;
    }

    protected static String getProtocol() {
        return protocol;
    }

    public static boolean isUsingSSL() {
        return PROTOCOL_HTTPS.equals(protocol);
    }

    public static void setKey(String pKey) {
        apiKey = pKey;
    }

    public static void setContentType(String pKey) {
        contentType = pKey;
    }

    public static void setSubscriptionKey(String pSubscriptionKey) {
        subscriptionKey = pSubscriptionKey;
    }

    public static void setHttpReferrer(String pReferrer) {
        referrer = pReferrer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken(String subscriptionKey) throws Exception {
        URL url = new URL(DatamarketAccessUri);
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        if (referrer != null) {
            uc.setRequestProperty("referer", referrer);
        }
        uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        uc.setRequestProperty("Accept-Charset", ENCODING);
        uc.setRequestMethod(HTTP_POST);
        uc.setDoOutput(true);
        uc.setRequestProperty(OcpApimSubscriptionKeyHeader, subscriptionKey);
        uc.setFixedLengthStreamingMode(0);
        OutputStreamWriter wr = new OutputStreamWriter(uc.getOutputStream());
        wr.write("");
        wr.flush();
        try {
            int responseCode = uc.getResponseCode();
            String result = MicrosoftTranslatorAPI.inputStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error retrieving token from Microsoft Translator API (" + responseCode + "): " + result);
            }
            String string = result;
            return string;
        }
        finally {
            uc.disconnect();
        }
    }

    public static void resetToken() {
        token = null;
        tokenExpiration = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String retrieveResponse(URL url) throws Exception {
        if (subscriptionKey != null && System.currentTimeMillis() > tokenExpiration) {
            String tokenKey = MicrosoftTranslatorAPI.getToken(subscriptionKey);
            tokenExpiration = System.currentTimeMillis() + tokenCacheExpiration;
            token = "Bearer " + tokenKey;
        }
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        if (referrer != null) {
            uc.setRequestProperty("referer", referrer);
        }
        uc.setRequestProperty("Content-Type", contentType + "; charset=" + ENCODING);
        uc.setRequestProperty("Accept-Charset", ENCODING);
        if (token != null) {
            uc.setRequestProperty("Authorization", token);
        }
        uc.setRequestMethod(HTTP_GET);
        uc.setDoOutput(true);
        try {
            int responseCode = uc.getResponseCode();
            String result = MicrosoftTranslatorAPI.inputStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error retrieving translation from Microsoft Translator API (" + responseCode + "): " + result);
            }
            String string = result;
            return string;
        }
        finally {
            uc.disconnect();
        }
    }

    protected String toJsonString(Object object) {
        return this.jsonUtil.writeJson(object);
    }

    protected RP retrieveResponseV3(URL url, String httpMethod, RQ requestBody, TypeReference<RP> type) throws Exception {
        return this.retrieveResponseV3(url, httpMethod, requestBody, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RP retrieveResponseV3(URL url, String httpMethod, RQ requestBody, TypeReference<RP> type, HashMap<String, String> headers) throws Exception {
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("Content-Type", "application/json");
        if (headers != null) {
            for (String key : headers.keySet()) {
                uc.setRequestProperty(key, headers.get(key));
            }
        }
        if (httpMethod == null) {
            httpMethod = HTTP_GET;
        }
        uc.setRequestMethod(httpMethod);
        uc.setDoOutput(true);
        uc.setRequestProperty(OcpApimSubscriptionKeyHeader, subscriptionKey);
        if (HTTP_POST.equals(httpMethod)) {
            String body = requestBody != null ? this.toJsonString(requestBody) : "";
            OutputStreamWriter wr = new OutputStreamWriter(uc.getOutputStream());
            wr.write(body);
            wr.flush();
        }
        try {
            RP result;
            int responseCode = uc.getResponseCode();
            String resultString = MicrosoftTranslatorAPI.inputStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error retrieving token from Microsoft Translator API (" + responseCode + "): " + resultString);
            }
            RP RP = result = this.jsonUtil.parseJson(resultString, type);
            return RP;
        }
        finally {
            uc.disconnect();
        }
    }

    protected static String retrieveString(URL url) throws Exception {
        try {
            String response = MicrosoftTranslatorAPI.retrieveResponse(url);
            return MicrosoftTranslatorAPI.jsonToString(response);
        }
        catch (Exception ex) {
            throw new Exception("[microsoft-translator-api] Error retrieving translation: " + ex.getMessage(), ex);
        }
    }

    protected static String[] retrieveStringArr(URL url, String jsonProperty) throws Exception {
        try {
            String response = MicrosoftTranslatorAPI.retrieveResponse(url);
            return MicrosoftTranslatorAPI.jsonToStringArr(response, jsonProperty);
        }
        catch (Exception ex) {
            throw new Exception("[microsoft-translator-api] Error retrieving translation: " + ex.getMessage(), ex);
        }
    }

    protected static String[] retrieveStringArr(URL url) throws Exception {
        return MicrosoftTranslatorAPI.retrieveStringArr(url, null);
    }

    protected static Integer[] retrieveIntArray(URL url) throws Exception {
        try {
            String response = MicrosoftTranslatorAPI.retrieveResponse(url);
            return MicrosoftTranslatorAPI.jsonToIntArr(response);
        }
        catch (Exception ex) {
            throw new Exception("[microsoft-translator-api] Error retrieving translation : " + ex.getMessage(), ex);
        }
    }

    private static Integer[] jsonToIntArr(String inputString) throws Exception {
        JSONArray jsonArr = (JSONArray)JSONValue.parse((String)inputString);
        Integer[] intArr = new Integer[jsonArr.size()];
        int i = 0;
        for (Object obj : jsonArr) {
            intArr[i] = ((Long)obj).intValue();
            ++i;
        }
        return intArr;
    }

    private static String jsonToString(String inputString) throws Exception {
        String json = (String)JSONValue.parse((String)inputString);
        return json;
    }

    private static String[] jsonToStringArr(String inputString, String propertyName) throws Exception {
        JSONArray jsonArr = (JSONArray)JSONValue.parse((String)inputString);
        String[] values = new String[jsonArr.size()];
        int i = 0;
        for (Object obj : jsonArr) {
            if (propertyName != null && propertyName.length() != 0) {
                JSONObject json = (JSONObject)obj;
                if (json.containsKey((Object)propertyName)) {
                    values[i] = json.get((Object)propertyName).toString();
                }
            } else {
                values[i] = obj.toString();
            }
            ++i;
        }
        return values;
    }

    private static String inputStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING));
                while (null != (string = reader.readLine())) {
                    outputBuilder.append(string.replaceAll("\ufeff", ""));
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("[microsoft-translator-api] Error reading translation stream: " + ex.getMessage(), ex);
        }
        return outputBuilder.toString();
    }

    protected static void validateServiceState() throws Exception {
        if (subscriptionKey == null) {
            throw new RuntimeException("Must provide a Windows Azure Marketplace SubscriptionKey - Please see https://www.microsoft.com/cognitive-services/en-us/translator-api/documentation/TranslatorInfo/overview for further documentation");
        }
    }

    protected static String buildStringArrayParam(Object[] values) {
        JSONArray list = new JSONArray();
        for (Object obj : values) {
            String value;
            if (obj == null || (value = obj.toString()).length() == 0) continue;
            list.add((Object)value);
        }
        return list.toJSONString();
    }

    static {
        DatamarketAccessUri = "https://api.cognitive.microsoft.com/sts/v1.0/issueToken";
        OcpApimSubscriptionKeyHeader = "Ocp-Apim-Subscription-Key";
        tokenCacheExpiration = 300000L;
        tokenExpiration = 0L;
        contentType = "text/plain";
    }
}

