/*
 * Decompiled with CFR 0.152.
 */
package io.github.firemaples.detect;

import io.github.firemaples.MicrosoftTranslatorAPI;
import io.github.firemaples.language.Language;
import io.github.firemaples.models.DetectResult;
import io.github.firemaples.models.TextArrayRequest;
import io.github.firemaples.utils.TypeReference;
import java.net.URL;

public final class Detect
extends MicrosoftTranslatorAPI<TextArrayRequest, DetectResult> {
    private static Detect instance = new Detect();
    private static final String SERVICE_URL = "api.cognitive.microsofttranslator.com/detect?api-version=3.0";

    private Detect() {
    }

    public static Language execute(String text) throws Exception {
        DetectResult results = Detect.retrieveResult(text);
        if (results != null && !results.isEmpty()) {
            return Language.fromString(((DetectResult.Result)results.get((int)0)).language);
        }
        throw new IllegalStateException("Parsing result failed");
    }

    public static String[] execute(String[] texts) throws Exception {
        DetectResult results = Detect.retrieveResult(texts);
        if (results != null && results.size() > 0) {
            String[] resultArray = new String[results.size()];
            for (int i = 0; i < results.size(); ++i) {
                resultArray[i] = ((DetectResult.Result)results.get((int)i)).language;
            }
            return resultArray;
        }
        throw new IllegalStateException("Parsing result failed");
    }

    public static DetectResult retrieveResult(String ... texts) throws Exception {
        Detect.validateServiceState(texts);
        URL url = new URL("https://api.cognitive.microsofttranslator.com/detect?api-version=3.0");
        DetectResult result = instance.retrieveResponseV3(url, "POST", TextArrayRequest.build(texts), new TypeReference<DetectResult>(){});
        return result;
    }

    private static void validateServiceState(String[] texts) throws Exception {
        if (texts.length > 100) {
            throw new RuntimeException("TEXT_COUNT_OVER_LIMIT - Microsoft Translator (Detect) can handle up to 100 texts per request");
        }
        for (String text : texts) {
            String json = instance.toJsonString(new TextArrayRequest.Text(text));
            if (json.length() <= 10000) continue;
            throw new RuntimeException("TEXT_TOO_LARGE - Microsoft Translator (Detect) can handle up to 10,000 characters per array element");
        }
        String json = instance.toJsonString(TextArrayRequest.build(texts));
        if (json.length() > 50000) {
            throw new RuntimeException("TEXT_TOO_LARGE - Microsoft Translator (Detect) can handle up to 50,000 characters per request");
        }
        Detect.validateServiceState();
    }
}

