/*
 * Decompiled with CFR 0.152.
 */
package io.github.firemaples.language;

import io.github.firemaples.MicrosoftTranslatorAPI;
import io.github.firemaples.models.LanguagesResult;
import io.github.firemaples.utils.TypeReference;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public enum Language {
    AUTO_DETECT(""),
    AFRIKAANS("af"),
    ARABIC("ar"),
    BANGLA("bn"),
    BOSNIAN("bs"),
    BULGARIAN("bg"),
    CANTONESE_TRADITIONAL("yue"),
    CATALAN("ca"),
    CHINESE_SIMPLIFIED("zh-Hans"),
    CHINESE_TRADITIONAL("zh-Hant"),
    CROATIAN("hr"),
    CZECH("cs"),
    DANISH("da"),
    DUTCH("nl"),
    ENGLISH("en"),
    ESTONIAN("et"),
    FIJIAN("fj"),
    FILIPINO("fil"),
    FINNISH("fi"),
    FRENCH("fr"),
    GERMAN("de"),
    GREEK("el"),
    HAITIAN_CREOLE("ht"),
    HEBREW("he"),
    HINDI("hi"),
    HMONG_DAW("mww"),
    HUNGARIAN("hu"),
    INDONESIAN("id"),
    ITALIAN("it"),
    JAPANESE("ja"),
    KISWAHILI("sw"),
    KLINGON("tlh"),
    KOREAN("ko"),
    LATVIAN("lv"),
    LITHUANIAN("lt"),
    MALAGASY("mg"),
    MALAY("ms"),
    MALTESE("mt"),
    NORWEGIAN("nb"),
    PERSIAN("fa"),
    POLISH("pl"),
    PORTUGUESE("pt"),
    QUER\u00c9TARO_OTOMI("otq"),
    ROMANIAN("ro"),
    RUSSIAN("ru"),
    SAMOAN("sm"),
    SERBIAN_CYRILLIC("sr-Cyrl"),
    SERBIAN_LATIN("sr-Latn"),
    SLOVAK("sk"),
    SLOVENIAN("sl"),
    SPANISH("es"),
    SWEDISH("sv"),
    TAHITIAN("ty"),
    THAI("th"),
    TONGAN("to"),
    TURKISH("tr"),
    UKRAINIAN("uk"),
    URDU("ur"),
    VIETNAMESE("vi"),
    WELSH("cy"),
    YUCATEC_MAYA("yua");

    private final String language;
    private Map<Language, String> localizedCache = new ConcurrentHashMap<Language, String>();

    private Language(String pLanguage) {
        this.language = pLanguage;
    }

    public static Language fromString(String pLanguage) {
        for (Language l : Language.values()) {
            if (!l.toString().equals(pLanguage)) continue;
            return l;
        }
        return null;
    }

    public String toString() {
        return this.language;
    }

    public static void setKey(String pKey) {
        LanguageService.setKey(pKey);
    }

    public static void setSubscriptionKey(String pSubscriptionKey) {
        LanguageService.setSubscriptionKey(pSubscriptionKey);
    }

    public static void resetToken() {
        LanguageService.resetToken();
    }

    public String getName(Language locale) throws Exception {
        String localizedName;
        if (this.localizedCache.containsKey((Object)locale)) {
            localizedName = this.localizedCache.get((Object)locale);
        } else if (this == AUTO_DETECT || locale == AUTO_DETECT) {
            localizedName = "Auto Detect";
        } else {
            LanguagesResult languagesResult = LanguageService.retrieveResult(locale);
            if (languagesResult != null && languagesResult.translation != null) {
                for (Language lang : Language.values()) {
                    LanguagesResult.TranslationLanguage resultLang = languagesResult.translation.get(lang.toString());
                    if (resultLang == null || resultLang.name == null) continue;
                    lang.localizedCache.put(locale, resultLang.name);
                }
                localizedName = this.localizedCache.get((Object)locale);
            } else {
                return null;
            }
        }
        return localizedName;
    }

    public static List<String> getLanguageCodesForTranslation() throws Exception {
        String[] codes = GetLanguagesForTranslateService.execute();
        return Arrays.asList(codes);
    }

    public static Map<String, Language> values(Language locale) throws Exception {
        TreeMap<String, Language> localizedMap = new TreeMap<String, Language>();
        for (Language lang : Language.values()) {
            if (lang == AUTO_DETECT) {
                localizedMap.put(AUTO_DETECT.name(), lang);
                continue;
            }
            localizedMap.put(lang.getName(locale), lang);
        }
        return localizedMap;
    }

    private void flushCache() {
        this.localizedCache.clear();
    }

    public static void flushNameCache() {
        for (Language lang : Language.values()) {
            lang.flushCache();
        }
    }

    private static final class GetLanguagesForTranslateService
    extends MicrosoftTranslatorAPI<Void, LanguagesResult> {
        private static GetLanguagesForTranslateService instance = new GetLanguagesForTranslateService();
        private static final String SERVICE_URL = "api.cognitive.microsofttranslator.com/languages?api-version=3.0";

        private GetLanguagesForTranslateService() {
        }

        public static String[] execute() throws Exception {
            LanguagesResult result = GetLanguagesForTranslateService.retrieveResult();
            if (result != null && result.translation != null) {
                return result.translation.keySet().toArray(new String[0]);
            }
            throw new IllegalStateException("Parsing result failed");
        }

        public static LanguagesResult retrieveResult() throws Exception {
            GetLanguagesForTranslateService.validateServiceState();
            URL url = new URL("https://api.cognitive.microsofttranslator.com/languages?api-version=3.0&scope=translation");
            LanguagesResult result = instance.retrieveResponseV3(url, "GET", null, new TypeReference<LanguagesResult>(){});
            return result;
        }
    }

    private static final class LanguageService
    extends MicrosoftTranslatorAPI<Void, LanguagesResult> {
        private static LanguageService instance = new LanguageService();
        private static final String SERVICE_URL = "api.cognitive.microsofttranslator.com/languages?api-version=3.0";

        private LanguageService() {
        }

        @Deprecated
        public static String[] execute(Language[] targets, Language locale) throws Exception {
            return new String[0];
        }

        public static LanguagesResult retrieveResult(Language locale) throws Exception {
            LanguageService.validateServiceState();
            URL url = new URL("https://api.cognitive.microsofttranslator.com/languages?api-version=3.0&scope=translation");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept-Language", locale.toString());
            LanguagesResult result = instance.retrieveResponseV3(url, "GET", null, new TypeReference<LanguagesResult>(){}, headers);
            return result;
        }
    }
}

