/*
 * Decompiled with CFR 0.152.
 */
package io.github.firemaples.sentence;

import io.github.firemaples.MicrosoftTranslatorAPI;
import io.github.firemaples.language.Language;
import io.github.firemaples.models.BreakSentencesResult;
import io.github.firemaples.models.TextArrayRequest;
import io.github.firemaples.utils.TypeReference;
import java.net.URL;
import java.net.URLEncoder;

public final class BreakSentences
extends MicrosoftTranslatorAPI<TextArrayRequest, BreakSentencesResult> {
    private static BreakSentences instance = new BreakSentences();
    private static final String SERVICE_URL = "api.cognitive.microsofttranslator.com/breaksentence?api-version=3.0";

    private BreakSentences() {
    }

    public static Integer[] execute(String text, Language fromLang) throws Exception {
        BreakSentencesResult results = BreakSentences.retrieveResult(fromLang, text);
        if (results != null && !results.isEmpty()) {
            return ((BreakSentencesResult.Result)results.get((int)0)).sentLen;
        }
        throw new IllegalStateException("Parsing result failed");
    }

    public static BreakSentencesResult retrieveResult(Language fromLang, String ... texts) throws Exception {
        BreakSentences.validateServiceState(texts);
        URL url = new URL("https://api.cognitive.microsofttranslator.com/breaksentence?api-version=3.0&language=" + URLEncoder.encode(fromLang.toString(), "UTF-8"));
        BreakSentencesResult result = instance.retrieveResponseV3(url, "POST", TextArrayRequest.build(texts), new TypeReference<BreakSentencesResult>(){});
        return result;
    }

    private static void validateServiceState(String[] texts) throws Exception {
        if (texts.length > 100) {
            throw new RuntimeException("TEXT_COUNT_OVER_LIMIT - Microsoft Translator (BreakSentences) can handle up to 100 texts per request");
        }
        for (String text : texts) {
            String json = instance.toJsonString(new TextArrayRequest.Text(text));
            if (json.length() <= 10000) continue;
            throw new RuntimeException("TEXT_TOO_LARGE - Microsoft Translator (BreakSentences) can handle up to 10,000 characters per array element");
        }
        String json = instance.toJsonString(TextArrayRequest.build(texts));
        if (json.length() > 50000) {
            throw new RuntimeException("TEXT_TOO_LARGE - Microsoft Translator (BreakSentences) can handle up to 50,000 characters per request");
        }
        BreakSentences.validateServiceState();
    }
}

