/*
 * Decompiled with CFR 0.152.
 */
package io.github.firemaples.translate;

import io.github.firemaples.MicrosoftTranslatorAPI;
import io.github.firemaples.language.Language;
import io.github.firemaples.models.TextArrayRequest;
import io.github.firemaples.models.TranslationResult;
import io.github.firemaples.utils.TypeReference;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

public final class Translate
extends MicrosoftTranslatorAPI<TextArrayRequest, TranslationResult> {
    private static Translate instance = new Translate();
    private static final String SERVICE_URL = "api.cognitive.microsofttranslator.com/translate?api-version=3.0";

    private Translate() {
    }

    public static String execute(String text, Language from, Language to) throws Exception {
        List<TranslationResult.Translation> translations;
        TranslationResult result = Translate.retrieveResult(from, to, text);
        if (result != null && result.size() > 0 && (translations = ((TranslationResult.Result)result.get((int)0)).translations) != null && translations.size() > 0) {
            return translations.get((int)0).text;
        }
        throw new IllegalStateException("Parsing result failed");
    }

    public static String execute(String text, Language to) throws Exception {
        return Translate.execute(text, Language.AUTO_DETECT, to);
    }

    public static String[] execute(String[] texts, Language from, Language to) throws Exception {
        TranslationResult result = Translate.retrieveResult(from, to, texts);
        if (result != null && result.size() > 0) {
            String[] resultArr = new String[result.size()];
            for (int i = 0; i < result.size(); ++i) {
                List<TranslationResult.Translation> translations = ((TranslationResult.Result)result.get((int)i)).translations;
                resultArr[i] = translations != null && translations.size() > 0 ? translations.get((int)0).text : "";
            }
            return resultArr;
        }
        throw new IllegalStateException("Parsing result failed");
    }

    public static String[] execute(String[] texts, Language to) throws Exception {
        return Translate.execute(texts, Language.AUTO_DETECT, to);
    }

    public static TranslationResult retrieveResult(Language from, Language to, String ... texts) throws Exception {
        Translate.validateServiceState(texts);
        String params = "&from=" + URLEncoder.encode(from.toString(), "UTF-8") + "&to=" + URLEncoder.encode(to.toString(), "UTF-8");
        URL url = new URL("https://api.cognitive.microsofttranslator.com/translate?api-version=3.0" + params);
        TranslationResult result = instance.retrieveResponseV3(url, "POST", TextArrayRequest.build(texts), new TypeReference<TranslationResult>(){});
        return result;
    }

    private static void validateServiceState(String[] texts) throws Exception {
        if (texts.length > 100) {
            throw new RuntimeException("TEXT_COUNT_OVER_LIMIT - Microsoft Translator (Translate) can handle up to 100 texts per request");
        }
        String json = instance.toJsonString(TextArrayRequest.build(texts));
        if (json.length() > 5000) {
            throw new RuntimeException("TEXT_TOO_LARGE - Microsoft Translator (Translate) can handle up to 5,000 characters per request");
        }
        Translate.validateServiceState();
    }
}

