/*
 * Decompiled with CFR 0.152.
 */
package io.github.firemaples.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.firemaples.utils.TypeReference;
import java.io.IOException;

public class JsonUtil<T> {
    private static Gson gson = null;
    private static GsonBuilder gsonBuilder = null;
    public static final ThreadLocal<Object> sThreadLocalReadObject = new ThreadLocal();

    public T parseJson(String str, Class<T> clazz) {
        try {
            sThreadLocalReadObject.set(clazz);
            Object object = this.defaultGson().fromJson(str, clazz);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            sThreadLocalReadObject.set(null);
        }
    }

    public <R> R parseJson(JsonObject json, Class<R> clazz) {
        try {
            sThreadLocalReadObject.set(clazz);
            Object object = this.defaultGson().fromJson((JsonElement)json, clazz);
            return (R)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            sThreadLocalReadObject.set(null);
        }
    }

    public T parseJson(String str, TypeReference<T> typeRef) {
        if (str == null) {
            return null;
        }
        if (String.class.equals((Object)typeRef.getType())) {
            return (T)str;
        }
        try {
            sThreadLocalReadObject.set(typeRef);
            Object object = this.defaultGson().fromJson(str, typeRef.getType());
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            sThreadLocalReadObject.set(null);
        }
    }

    public String writeJson(Object obj) {
        try {
            return this.defaultGson().toJson(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Gson defaultGson() {
        if (gson == null) {
            gson = this.defaultGsonBuilder().create();
        }
        return gson;
    }

    private GsonBuilder defaultGsonBuilder() {
        if (gsonBuilder != null) {
            return gsonBuilder;
        }
        gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new BooleanTypeAdapterFactory());
        return gsonBuilder;
    }

    public void registerTypeAdapter(Class<T> type, Object deser) {
        this.defaultGsonBuilder().registerTypeAdapter(type, deser);
    }

    public class BooleanTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            Class rawType = type.getRawType();
            if (rawType.equals(Boolean.TYPE) || rawType.equals(Boolean.class)) {
                return new TypeAdapter<T>(){

                    public void write(JsonWriter out, T value) throws IOException {
                        delegate.write(out, value);
                    }

                    public T read(JsonReader in) throws IOException {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            return null;
                        }
                        if (in.peek() == JsonToken.STRING) {
                            String s = in.nextString();
                            if (s.equalsIgnoreCase("true") || s.equals("1")) {
                                return true;
                            }
                            if (s.equalsIgnoreCase("false") || s.equals("0")) {
                                return false;
                            }
                        } else if (in.peek() == JsonToken.NUMBER) {
                            int i = in.nextInt();
                            if (i == 1) {
                                return true;
                            }
                            if (i == 0) {
                                return false;
                            }
                        }
                        return delegate.read(in);
                    }
                };
            }
            return delegate;
        }
    }
}

