/*
 * Decompiled with CFR 0.152.
 */
package io.github.flashvayne.chatgpt.autoconfig;

import io.github.flashvayne.chatgpt.property.ChatgptProperties;
import io.github.flashvayne.chatgpt.service.ChatgptService;
import io.github.flashvayne.chatgpt.service.impl.DefaultChatgptService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ChatgptProperties.class})
public class ChatgptAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ChatgptAutoConfiguration.class);
    @Autowired
    private ChatgptProperties chatgptProperties;

    public ChatgptAutoConfiguration() {
        log.debug("chatgpt-springboot-starter loaded.");
    }

    @Bean
    @ConditionalOnMissingBean(value={ChatgptService.class})
    public ChatgptService chatgptService() {
        return new DefaultChatgptService(this.chatgptProperties);
    }
}

