/*
 * Decompiled with CFR 0.152.
 */
package io.github.flashvayne.chatgpt.service.impl;

import io.github.flashvayne.chatgpt.dto.ChatRequest;
import io.github.flashvayne.chatgpt.dto.ChatResponse;
import io.github.flashvayne.chatgpt.exception.ChatgptException;
import io.github.flashvayne.chatgpt.property.ChatgptProperties;
import io.github.flashvayne.chatgpt.service.ChatgptService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DefaultChatgptService
implements ChatgptService {
    private static final Logger log = LoggerFactory.getLogger(DefaultChatgptService.class);
    protected final ChatgptProperties chatgptProperties;
    private final String URL = "https://api.openai.com/v1/completions";
    private final String AUTHORIZATION;

    public DefaultChatgptService(ChatgptProperties chatgptProperties) {
        this.chatgptProperties = chatgptProperties;
        this.AUTHORIZATION = "Bearer " + chatgptProperties.getApiKey();
    }

    @Override
    public String sendMessage(String message) {
        ChatRequest chatRequest = new ChatRequest(this.chatgptProperties.getModel(), message, this.chatgptProperties.getMaxTokens(), this.chatgptProperties.getTemperature(), this.chatgptProperties.getTopP());
        ChatResponse chatResponse = this.getResponse(this.buildHttpEntity(chatRequest));
        try {
            return chatResponse.getChoices().get(0).getText();
        }
        catch (Exception e) {
            log.error("parse chatgpt message error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public ChatResponse sendChatRequest(ChatRequest chatRequest) {
        return this.getResponse(this.buildHttpEntity(chatRequest));
    }

    public HttpEntity<ChatRequest> buildHttpEntity(ChatRequest chatRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/json; charset=UTF-8"));
        headers.add("Authorization", this.AUTHORIZATION);
        return new HttpEntity((Object)chatRequest, (MultiValueMap)headers);
    }

    public ChatResponse getResponse(HttpEntity<ChatRequest> chatRequestHttpEntity) {
        log.info("request url: {}, httpEntity: {}", (Object)"https://api.openai.com/v1/completions", chatRequestHttpEntity);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.postForEntity("https://api.openai.com/v1/completions", chatRequestHttpEntity, ChatResponse.class, new Object[0]);
        if (responseEntity.getStatusCode().isError()) {
            log.error("error response status: {}", (Object)responseEntity);
            throw new ChatgptException("error response status :" + responseEntity.getStatusCode().value());
        }
        log.info("response: {}", (Object)responseEntity);
        return (ChatResponse)responseEntity.getBody();
    }
}

