/*
 * Decompiled with CFR 0.152.
 */
package com.advance.supplier.ks;

import android.app.Activity;
import android.support.annotation.Nullable;
import com.advance.AdvanceFullScreenItem;
import com.advance.BaseParallelAdapter;
import com.advance.BaseSetting;
import com.advance.FullScreenVideoSetting;
import com.advance.model.AdvanceError;
import com.advance.supplier.ks.KSFullScreenItem;
import com.advance.supplier.ks.KSUtil;
import com.advance.utils.LogUtil;
import com.kwad.sdk.api.KsAdSDK;
import com.kwad.sdk.api.KsFullScreenVideoAd;
import com.kwad.sdk.api.KsLoadManager;
import com.kwad.sdk.api.KsScene;
import java.util.List;

public class KSFullScreenVideoAdapter
extends BaseParallelAdapter
implements KsFullScreenVideoAd.FullScreenVideoAdInteractionListener {
    public FullScreenVideoSetting setting;
    private String TAG = "[KSFullScreenVideoAdapter] ";
    private List<KsFullScreenVideoAd> list;

    public KSFullScreenVideoAdapter(Activity activity, FullScreenVideoSetting baseSetting) {
        super(activity, (BaseSetting)baseSetting);
        this.setting = baseSetting;
    }

    protected void doInit() {
        boolean initOK = KSUtil.initAD(this);
        if (initOK) {
            KsScene scene = new KsScene.Builder(KSUtil.getADID(this.sdkSupplier)).build();
            KsAdSDK.getLoadManager().loadFullScreenVideoAd(scene, new KsLoadManager.FullScreenVideoAdListener(){

                @Override
                public void onError(int code, String msg) {
                    LogUtil.e((String)(KSFullScreenVideoAdapter.this.TAG + " onError " + code + msg));
                    AdvanceError error = AdvanceError.parseErr((int)code, (String)msg);
                    if (KSFullScreenVideoAdapter.this.isParallel) {
                        if (KSFullScreenVideoAdapter.this.parallelListener != null) {
                            KSFullScreenVideoAdapter.this.parallelListener.onFailed(error);
                        }
                    } else {
                        KSFullScreenVideoAdapter.this.runBaseFailed(error);
                    }
                }

                @Override
                public void onRequestResult(int adNumber) {
                    LogUtil.d((String)(KSFullScreenVideoAdapter.this.TAG + "\u5e7f\u544a\u586b\u5145\u6570\u91cf\uff1a" + adNumber));
                }

                @Override
                public void onFullScreenVideoAdLoad(@Nullable List<KsFullScreenVideoAd> adList) {
                    LogUtil.d((String)(KSFullScreenVideoAdapter.this.TAG + " onFullScreenVideoAdLoad"));
                    try {
                        KSFullScreenVideoAdapter.this.list = adList;
                        if (KSFullScreenVideoAdapter.this.isParallel) {
                            if (KSFullScreenVideoAdapter.this.parallelListener != null) {
                                KSFullScreenVideoAdapter.this.parallelListener.onSucceed();
                            }
                        } else {
                            KSFullScreenVideoAdapter.this.doLoad();
                        }
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                        KSFullScreenVideoAdapter.this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
                    }
                }
            });
        }
    }

    protected void doLoad() {
        try {
            if (this.list == null || this.list.size() == 0) {
                this.runBaseFailed(AdvanceError.parseErr((String)"9901"));
            } else {
                KsFullScreenVideoAd ad2 = this.list.get(0);
                KSFullScreenItem item = new KSFullScreenItem(this.activity, this, ad2);
                if (ad2 != null && ad2.isAdEnable()) {
                    ad2.setFullScreenVideoAdInteractionListener(this);
                }
                if (null != this.setting) {
                    this.setting.adapterAdDidLoaded((AdvanceFullScreenItem)item, this.sdkSupplier);
                }
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
        }
    }

    public void doDestroy() {
    }

    public void orderLoadAd() {
        try {
            this.doInit();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
        }
    }

    @Override
    public void onAdClicked() {
        LogUtil.d((String)(this.TAG + " onAdClicked"));
        if (this.setting != null) {
            this.setting.adapterDidClicked(this.sdkSupplier);
        }
    }

    @Override
    public void onPageDismiss() {
        LogUtil.d((String)(this.TAG + " onPageDismiss"));
        if (this.setting != null) {
            this.setting.adapterClose();
        }
    }

    @Override
    public void onVideoPlayError(int code, int extra) {
        String msg = " onVideoPlayError,code = " + code + ",extra = " + extra;
        LogUtil.e((String)(this.TAG + msg));
        try {
            if (this.setting != null) {
                AdvanceError error = AdvanceError.parseErr((String)"9904", (String)msg);
                this.runBaseFailed(error);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void onVideoPlayEnd() {
        LogUtil.d((String)(this.TAG + " onVideoPlayEnd"));
        if (this.setting != null) {
            this.setting.adapterVideoComplete();
        }
    }

    @Override
    public void onVideoPlayStart() {
        LogUtil.d((String)(this.TAG + " onVideoPlayStart"));
        if (this.setting != null) {
            this.setting.adapterDidShow(this.sdkSupplier);
        }
    }

    @Override
    public void onSkippedVideo() {
        LogUtil.d((String)(this.TAG + " onSkippedVideo"));
        if (this.setting != null) {
            this.setting.adapterVideoSkipped();
        }
    }
}

