/*
 * Decompiled with CFR 0.152.
 */
package com.advance.supplier.ks;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.advance.BaseInterstitialAdapter;
import com.advance.BaseParallelAdapter;
import com.advance.BaseSetting;
import com.advance.InterstitialSetting;
import com.advance.model.AdvanceError;
import com.advance.supplier.ks.AdvanceKSManager;
import com.advance.supplier.ks.KSUtil;
import com.advance.utils.LogUtil;
import com.kwad.sdk.api.KsAdSDK;
import com.kwad.sdk.api.KsInterstitialAd;
import com.kwad.sdk.api.KsLoadManager;
import com.kwad.sdk.api.KsScene;
import java.util.List;

public class KSInterstitialAdapter
extends BaseInterstitialAdapter
implements KsInterstitialAd.AdInteractionListener {
    private InterstitialSetting setting;
    KsInterstitialAd interstitialAD;
    List<KsInterstitialAd> list;
    private String TAG = "[KSInterstitialAdapter] ";

    public KSInterstitialAdapter(Activity activity, InterstitialSetting baseSetting) {
        super(activity, (BaseSetting)baseSetting);
        this.setting = baseSetting;
    }

    public void show() {
        try {
            boolean isMainThread;
            boolean bl2 = isMainThread = Looper.myLooper() == Looper.getMainLooper();
            if (isMainThread) {
                this.doShow();
            } else {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        LogUtil.AdvanceLog((String)"force to main thread run show");
                        KSInterstitialAdapter.this.doShow();
                    }
                });
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9903"));
        }
    }

    private void doShow() {
        if (this.interstitialAD != null) {
            this.interstitialAD.showInterstitialAd(this.activity, AdvanceKSManager.getInstance().interstitialVideoConfig);
        }
    }

    protected void doInit() {
        boolean initOK = KSUtil.initAD((BaseParallelAdapter)this);
        if (initOK) {
            KsScene scene = new KsScene.Builder(KSUtil.getADID(this.sdkSupplier)).build();
            KsAdSDK.getLoadManager().loadInterstitialAd(scene, new KsLoadManager.InterstitialAdListener(){

                @Override
                public void onError(int code, String msg) {
                    LogUtil.e((String)(KSInterstitialAdapter.this.TAG + " onError " + code + msg));
                    AdvanceError error = AdvanceError.parseErr((int)code, (String)msg);
                    if (KSInterstitialAdapter.this.isParallel) {
                        if (KSInterstitialAdapter.this.parallelListener != null) {
                            KSInterstitialAdapter.this.parallelListener.onFailed(error);
                        }
                    } else {
                        KSInterstitialAdapter.this.runBaseFailed(error);
                    }
                }

                @Override
                public void onRequestResult(int adNumber) {
                    LogUtil.d((String)(KSInterstitialAdapter.this.TAG + "\u5e7f\u544a\u586b\u5145\u6570\u91cf\uff1a" + adNumber));
                }

                @Override
                public void onInterstitialAdLoad(@Nullable List<KsInterstitialAd> adList) {
                    LogUtil.d((String)(KSInterstitialAdapter.this.TAG + "onInterstitialAdLoad"));
                    try {
                        KSInterstitialAdapter.this.list = adList;
                        if (KSInterstitialAdapter.this.isParallel) {
                            if (KSInterstitialAdapter.this.parallelListener != null) {
                                KSInterstitialAdapter.this.parallelListener.onSucceed();
                            }
                        } else {
                            KSInterstitialAdapter.this.doLoad();
                        }
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                        KSInterstitialAdapter.this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
                    }
                }
            });
        }
    }

    protected void doLoad() {
        try {
            if (this.list == null || this.list.size() == 0) {
                this.runBaseFailed(AdvanceError.parseErr((String)"9901"));
            } else {
                this.interstitialAD = this.list.get(0);
                if (this.interstitialAD != null) {
                    this.interstitialAD.setAdInteractionListener(this);
                }
                if (null != this.setting) {
                    this.setting.adapterDidSucceed(this.sdkSupplier);
                }
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
        }
    }

    public void doDestroy() {
    }

    public void orderLoadAd() {
        try {
            this.doInit();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
        }
    }

    @Override
    public void onAdClicked() {
        LogUtil.d((String)(this.TAG + " onAdClicked"));
        if (this.setting != null) {
            this.setting.adapterDidClicked(this.sdkSupplier);
        }
    }

    @Override
    public void onAdShow() {
        LogUtil.d((String)(this.TAG + " onAdShow"));
        if (this.setting != null) {
            this.setting.adapterDidShow(this.sdkSupplier);
        }
    }

    @Override
    public void onAdClosed() {
        LogUtil.d((String)(this.TAG + " onAdClosed"));
        if (this.setting != null) {
            this.setting.adapterDidClosed();
        }
    }

    @Override
    public void onPageDismiss() {
        LogUtil.d((String)(this.TAG + " onPageDismiss"));
        if (this.setting != null) {
            this.setting.adapterDidClosed();
        }
    }

    @Override
    public void onVideoPlayError(int code, int extra) {
        LogUtil.e((String)(this.TAG + " onVideoPlayError,code = " + code + ",extra = " + extra));
        try {
            if (this.setting != null) {
                AdvanceError error = AdvanceError.parseErr((String)"9904", (String)"onVideoPlayError");
                this.setting.adapterDidFailed(error);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void onVideoPlayEnd() {
        LogUtil.d((String)(this.TAG + " onVideoPlayEnd"));
    }

    @Override
    public void onVideoPlayStart() {
        LogUtil.d((String)(this.TAG + " onVideoPlayStart"));
    }

    @Override
    public void onSkippedAd() {
        LogUtil.d((String)(this.TAG + " onSkippedAd"));
        if (this.setting != null) {
            this.setting.adapterDidClosed();
        }
    }
}

