/*
 * Decompiled with CFR 0.152.
 */
package com.advance.supplier.ks;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import com.advance.BaseParallelAdapter;
import com.advance.BaseSetting;
import com.advance.NativeExpressSetting;
import com.advance.model.AdvanceError;
import com.advance.supplier.ks.KSNativeExpressItem;
import com.advance.supplier.ks.KSUtil;
import com.advance.utils.LogUtil;
import com.kwad.sdk.api.KsAdSDK;
import com.kwad.sdk.api.KsFeedAd;
import com.kwad.sdk.api.KsLoadManager;
import com.kwad.sdk.api.KsScene;
import java.util.ArrayList;
import java.util.List;

public class KSNativeExpressAdapter
extends BaseParallelAdapter {
    private String TAG = "[KSNativeExpressAdapter] ";
    public NativeExpressSetting setting;
    List<KsFeedAd> list;

    public KSNativeExpressAdapter(Activity activity, NativeExpressSetting baseSetting) {
        super(activity, (BaseSetting)baseSetting);
        this.setting = baseSetting;
    }

    protected void doInit() {
        boolean initOK = KSUtil.initAD(this);
        if (initOK) {
            int num = this.sdkSupplier != null ? this.sdkSupplier.adCount : 1;
            KsScene scene = new KsScene.Builder(KSUtil.getADID(this.sdkSupplier)).adNum(num).build();
            KsAdSDK.getLoadManager().loadConfigFeedAd(scene, new KsLoadManager.FeedAdListener(){

                @Override
                public void onError(int code, String msg) {
                    LogUtil.e((String)(KSNativeExpressAdapter.this.TAG + " onError " + code + msg));
                    AdvanceError error = AdvanceError.parseErr((int)code, (String)msg);
                    if (KSNativeExpressAdapter.this.isParallel) {
                        if (KSNativeExpressAdapter.this.parallelListener != null) {
                            KSNativeExpressAdapter.this.parallelListener.onFailed(error);
                        }
                    } else {
                        KSNativeExpressAdapter.this.runBaseFailed(error);
                    }
                }

                @Override
                public void onFeedAdLoad(@Nullable List<KsFeedAd> adList) {
                    LogUtil.d((String)(KSNativeExpressAdapter.this.TAG + " onFeedAdLoad"));
                    KSNativeExpressAdapter.this.list = adList;
                    try {
                        if (KSNativeExpressAdapter.this.isParallel) {
                            if (KSNativeExpressAdapter.this.parallelListener != null) {
                                KSNativeExpressAdapter.this.parallelListener.onSucceed();
                            }
                        } else {
                            KSNativeExpressAdapter.this.doLoad();
                        }
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                        KSNativeExpressAdapter.this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
                    }
                }
            });
        }
    }

    protected void doLoad() {
        try {
            if (this.list == null || this.list.size() == 0) {
                this.runBaseFailed(AdvanceError.parseErr((String)"9901"));
            } else {
                ArrayList<KSNativeExpressItem> advanceNativeExpressAdItemList = new ArrayList<KSNativeExpressItem>();
                for (final KsFeedAd adItem : this.list) {
                    if (adItem == null) continue;
                    KSNativeExpressItem advanceNativeExpressAdItem = new KSNativeExpressItem(this.activity, this, adItem);
                    advanceNativeExpressAdItemList.add(advanceNativeExpressAdItem);
                    try {
                        if (adItem == null) continue;
                        final View adview = adItem.getFeedView((Context)this.activity);
                        adItem.setAdInteractionListener(new KsFeedAd.AdInteractionListener(){

                            @Override
                            public void onAdClicked() {
                                LogUtil.d((String)(KSNativeExpressAdapter.this.TAG + " onAdClicked " + adItem.toString()));
                                if (KSNativeExpressAdapter.this.setting != null) {
                                    KSNativeExpressAdapter.this.setting.adapterDidClicked(adview, KSNativeExpressAdapter.this.sdkSupplier);
                                }
                            }

                            @Override
                            public void onAdShow() {
                                LogUtil.d((String)(KSNativeExpressAdapter.this.TAG + " onAdShow " + adItem.toString()));
                                if (KSNativeExpressAdapter.this.setting != null) {
                                    KSNativeExpressAdapter.this.setting.adapterDidShow(adview, KSNativeExpressAdapter.this.sdkSupplier);
                                }
                            }

                            @Override
                            public void onDislikeClicked() {
                                LogUtil.d((String)(KSNativeExpressAdapter.this.TAG + " onDislikeClicked " + adItem.toString()));
                                if (KSNativeExpressAdapter.this.setting != null) {
                                    KSNativeExpressAdapter.this.setting.adapterDidClosed(adview);
                                }
                            }
                        });
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                    }
                }
                if (null != this.setting) {
                    this.setting.adapterAdDidLoaded(advanceNativeExpressAdItemList, this.sdkSupplier);
                }
            }
        }
        catch (Throwable e3) {
            e3.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
        }
    }

    public void doDestroy() {
    }

    public void orderLoadAd() {
        try {
            this.doInit();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
        }
    }
}

