/*
 * Decompiled with CFR 0.152.
 */
package com.advance.supplier.ks;

import android.app.Activity;
import android.support.annotation.Nullable;
import com.advance.AdvanceRewardVideoItem;
import com.advance.BaseParallelAdapter;
import com.advance.BaseSetting;
import com.advance.RewardVideoSetting;
import com.advance.model.AdvanceError;
import com.advance.supplier.ks.KSRewardItem;
import com.advance.supplier.ks.KSUtil;
import com.advance.utils.LogUtil;
import com.kwad.sdk.api.KsAdSDK;
import com.kwad.sdk.api.KsLoadManager;
import com.kwad.sdk.api.KsRewardVideoAd;
import com.kwad.sdk.api.KsScene;
import java.util.List;

public class KSRewardAdapter
extends BaseParallelAdapter
implements KsRewardVideoAd.RewardAdInteractionListener {
    public RewardVideoSetting setting;
    private String TAG = "[KSRewardAdapter] ";
    private List<KsRewardVideoAd> list;

    public KSRewardAdapter(Activity activity, RewardVideoSetting baseSetting) {
        super(activity, (BaseSetting)baseSetting);
        this.setting = baseSetting;
    }

    protected void doInit() {
        boolean initOK = KSUtil.initAD(this);
        if (initOK) {
            KsScene scene = new KsScene.Builder(KSUtil.getADID(this.sdkSupplier)).build();
            KsAdSDK.getLoadManager().loadRewardVideoAd(scene, new KsLoadManager.RewardVideoAdListener(){

                @Override
                public void onError(int code, String msg) {
                    LogUtil.e((String)(KSRewardAdapter.this.TAG + " onError " + code + msg));
                    AdvanceError error = AdvanceError.parseErr((int)code, (String)msg);
                    if (KSRewardAdapter.this.isParallel) {
                        if (KSRewardAdapter.this.parallelListener != null) {
                            KSRewardAdapter.this.parallelListener.onFailed(error);
                        }
                    } else {
                        KSRewardAdapter.this.runBaseFailed(error);
                    }
                }

                @Override
                public void onRequestResult(int adNumber) {
                    LogUtil.d((String)(KSRewardAdapter.this.TAG + "\u5e7f\u544a\u586b\u5145\u6570\u91cf\uff1a" + adNumber));
                }

                @Override
                public void onRewardVideoAdLoad(@Nullable List<KsRewardVideoAd> adList) {
                    LogUtil.d((String)(KSRewardAdapter.this.TAG + " onRewardVideoAdLoad"));
                    try {
                        KSRewardAdapter.this.list = adList;
                        if (KSRewardAdapter.this.isParallel) {
                            if (KSRewardAdapter.this.parallelListener != null) {
                                KSRewardAdapter.this.parallelListener.onSucceed();
                            }
                        } else {
                            KSRewardAdapter.this.doLoad();
                        }
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                        KSRewardAdapter.this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
                    }
                }
            });
        }
    }

    protected void doLoad() {
        try {
            if (this.list == null || this.list.size() == 0) {
                this.runBaseFailed(AdvanceError.parseErr((String)"9901"));
            } else {
                KsRewardVideoAd ad2 = this.list.get(0);
                KSRewardItem item = new KSRewardItem(this.activity, this, ad2);
                if (ad2 != null) {
                    ad2.setRewardAdInteractionListener(this);
                }
                if (null != this.setting) {
                    this.setting.adapterAdDidLoaded((AdvanceRewardVideoItem)item, this.sdkSupplier);
                }
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
        }
    }

    public void doDestroy() {
    }

    public void orderLoadAd() {
        try {
            this.doInit();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
        }
    }

    @Override
    public void onAdClicked() {
        LogUtil.d((String)(this.TAG + " onAdClicked"));
        if (this.setting != null) {
            this.setting.adapterDidClicked(this.sdkSupplier);
        }
    }

    @Override
    public void onPageDismiss() {
        LogUtil.d((String)(this.TAG + " onPageDismiss"));
        if (this.setting != null) {
            this.setting.adapterAdClose();
        }
    }

    @Override
    public void onVideoPlayError(int code, int extra) {
        String msg = " onVideoPlayError,code = " + code + ",extra = " + extra;
        LogUtil.e((String)(this.TAG + msg));
        try {
            if (this.setting != null) {
                AdvanceError error = AdvanceError.parseErr((String)"9904", (String)msg);
                this.runBaseFailed(error);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void onVideoPlayEnd() {
        LogUtil.d((String)(this.TAG + " onVideoPlayEnd"));
        if (this.setting != null) {
            this.setting.adapterVideoComplete();
        }
    }

    @Override
    public void onVideoPlayStart() {
        LogUtil.d((String)(this.TAG + " onVideoPlayStart"));
        if (this.setting != null) {
            this.setting.adapterDidShow(this.sdkSupplier);
        }
    }

    @Override
    public void onRewardVerify() {
        LogUtil.d((String)(this.TAG + " onRewardVerify"));
        if (this.setting != null) {
            this.setting.adapterAdReward();
        }
    }
}

