/*
 * Decompiled with CFR 0.152.
 */
package com.advance.supplier.ks;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.advance.BaseParallelAdapter;
import com.advance.BaseSplashAdapter;
import com.advance.SplashSetting;
import com.advance.model.AdvanceError;
import com.advance.supplier.ks.KSUtil;
import com.advance.utils.AdvanceUtil;
import com.advance.utils.LogUtil;
import com.kwad.sdk.api.KsAdSDK;
import com.kwad.sdk.api.KsLoadManager;
import com.kwad.sdk.api.KsScene;
import com.kwad.sdk.api.KsSplashScreenAd;
import java.lang.ref.SoftReference;

public class KSSplashAdapter
extends BaseSplashAdapter
implements KsSplashScreenAd.SplashScreenAdInteractionListener {
    private String TAG = "[KSSplashAdapter] ";
    private KsSplashScreenAd splashAd;

    public KSSplashAdapter(SoftReference<Activity> softReferenceActivity, SplashSetting baseSetting) {
        super(softReferenceActivity, baseSetting);
    }

    protected void doInit() {
        boolean initOK = KSUtil.initAD((BaseParallelAdapter)this);
        if (initOK) {
            KsScene scene = new KsScene.Builder(KSUtil.getADID(this.sdkSupplier)).build();
            KsAdSDK.getLoadManager().loadSplashScreenAd(scene, new KsLoadManager.SplashScreenAdListener(){

                @Override
                public void onError(int code, String msg) {
                    LogUtil.e((String)(KSSplashAdapter.this.TAG + " onError " + code + msg));
                    AdvanceError error = AdvanceError.parseErr((int)code, (String)msg);
                    if (KSSplashAdapter.this.isParallel) {
                        if (KSSplashAdapter.this.parallelListener != null) {
                            KSSplashAdapter.this.parallelListener.onFailed(error);
                        }
                    } else {
                        KSSplashAdapter.this.runBaseFailed(error);
                    }
                }

                @Override
                public void onRequestResult(int adNumber) {
                    LogUtil.d((String)(KSSplashAdapter.this.TAG + "\u5e7f\u544a\u586b\u5145\u6570\u91cf\uff1a" + adNumber));
                }

                @Override
                public void onSplashScreenAdLoad(@NonNull KsSplashScreenAd splashScreenAd) {
                    LogUtil.d((String)(KSSplashAdapter.this.TAG + "onSplashScreenAdLoad"));
                    try {
                        if (splashScreenAd == null) {
                            String nMsg = KSSplashAdapter.this.TAG + " KsSplashScreenAd null";
                            AdvanceError error = AdvanceError.parseErr((String)"9901", (String)nMsg);
                            if (KSSplashAdapter.this.isParallel) {
                                if (KSSplashAdapter.this.parallelListener != null) {
                                    KSSplashAdapter.this.parallelListener.onFailed(error);
                                }
                            } else {
                                KSSplashAdapter.this.runBaseFailed(error);
                            }
                            return;
                        }
                        KSSplashAdapter.this.splashAd = splashScreenAd;
                        if (KSSplashAdapter.this.isParallel) {
                            if (KSSplashAdapter.this.parallelListener != null) {
                                KSSplashAdapter.this.parallelListener.onSucceed();
                            }
                        } else {
                            KSSplashAdapter.this.doLoad();
                        }
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                        KSSplashAdapter.this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
                    }
                }
            });
        }
    }

    protected void doLoad() {
        if (this.splashAd != null) {
            View view = this.splashAd.getView((Context)this.getADActivity(), this);
            if (!AdvanceUtil.isActivityDestroyed((SoftReference)this.softReferenceActivity)) {
                this.adContainer.removeAllViews();
                view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                this.adContainer.addView(view);
                if (this.skipView != null) {
                    this.skipView.setVisibility(4);
                }
                if (this.setting != null) {
                    this.setting.adapterDidSucceed(this.sdkSupplier);
                }
            }
        }
    }

    public void doDestroy() {
    }

    public void orderLoadAd() {
        try {
            if (this.setting != null && this.setting.getGdtSkipContainer() != null) {
                this.setting.getGdtSkipContainer().setVisibility(8);
            }
            this.doInit();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.runBaseFailed(AdvanceError.parseErr((String)"9902"));
            String cause = e2.getCause() != null ? e2.getCause().toString() : "no cause";
            this.reportCodeErr(this.TAG + " Throwable" + cause);
        }
    }

    @Override
    public void onAdClicked() {
        LogUtil.d((String)(this.TAG + "onAdClicked"));
        if (this.setting != null) {
            this.setting.adapterDidClicked(this.sdkSupplier);
        }
    }

    @Override
    public void onAdShowError(int code, String extra) {
        String msg = ",\u5f00\u5c4f\u5e7f\u544a\u663e\u793a\u9519\u8bef ,code =" + code + " extra " + extra;
        LogUtil.e((String)(this.TAG + "onAdShowError" + msg));
        this.splashAd = null;
        AdvanceError error = AdvanceError.parseErr((String)"9904", (String)msg);
        if (this.isParallel) {
            if (this.parallelListener != null) {
                this.parallelListener.onFailed(error);
            }
        } else {
            this.runBaseFailed(error);
        }
    }

    @Override
    public void onAdShowEnd() {
        LogUtil.d((String)(this.TAG + "onAdShowEnd"));
        if (this.setting != null) {
            this.setting.adapterDidTimeOver();
        }
    }

    @Override
    public void onAdShowStart() {
        LogUtil.d((String)(this.TAG + "onAdShowStart"));
        if (this.setting != null) {
            this.setting.adapterDidShow(this.sdkSupplier);
        }
    }

    @Override
    public void onSkippedAd() {
        LogUtil.d((String)(this.TAG + "onSkippedAd"));
        if (this.setting != null) {
            this.setting.adapterDidSkip();
        }
    }
}

