/*
 * Decompiled with CFR 0.152.
 */
package com.advance.supplier.ks;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.advance.AdvanceConfig;
import com.advance.AdvanceSetting;
import com.advance.BaseParallelAdapter;
import com.advance.model.AdvanceError;
import com.advance.model.SdkSupplier;
import com.advance.utils.LogUtil;
import com.kwad.sdk.api.KsAdSDK;
import com.kwad.sdk.api.SdkConfig;
import java.util.List;

public class KSUtil {
    public static boolean initAD(BaseParallelAdapter adapter) {
        boolean hasInit = KSUtil.doInitAD(adapter);
        try {
            LogUtil.d((String)("KS hasInit =  " + hasInit));
            if (!hasInit) {
                AdvanceError error = AdvanceError.parseErr((String)"9914");
                if (adapter.isParallel) {
                    if (adapter.parallelListener != null) {
                        adapter.parallelListener.onFailed(error);
                    }
                } else {
                    adapter.runBaseFailed(error);
                }
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        return hasInit;
    }

    public static boolean doInitAD(BaseParallelAdapter adapter) {
        boolean initSuccess = false;
        try {
            Activity context;
            String currentProcessName;
            if (adapter == null) {
                LogUtil.e((String)"initAD failed BaseParallelAdapter null");
                return false;
            }
            boolean hasInit = AdvanceSetting.getInstance().hasKSInit;
            if (hasInit && adapter.canOptInit()) {
                return true;
            }
            SdkSupplier supplier = adapter.sdkSupplier;
            if (supplier == null) {
                LogUtil.e((String)"initAD failed BaseParallelAdapter null");
                return false;
            }
            String appId = supplier.mediaid;
            long id2 = KSUtil.getADID(supplier);
            if (id2 < 0L) {
                LogUtil.e((String)"initAD failed \u5feb\u624bSDK\u52a0\u8f7d\u5931\u8d25\uff0c\u5e7f\u544a\u4f4did\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38 ");
                return false;
            }
            String settingAppId = AdvanceConfig.getInstance().getKsAppId();
            LogUtil.d((String)("\u5feb\u624b\u521d\u59cb\u5316\u914d\u7f6e\u7684 appId = " + settingAppId + "\uff0c\u7b56\u7565\u670d\u52a1\u4e0b\u53d1\u7684 appId = " + appId));
            if (!TextUtils.isEmpty((CharSequence)settingAppId)) {
                appId = settingAppId;
            }
            if ((currentProcessName = KSUtil.getCurrentProcessName((Context)(context = adapter.getADActivity()))).equals(context.getPackageName())) {
                KsAdSDK.init((Context)context, new SdkConfig.Builder().appId(appId).appName(AdvanceConfig.getInstance().getKsAppName()).appKey(AdvanceConfig.getInstance().getKsAppKey()).appWebKey(AdvanceConfig.getInstance().getKsAppWebKey()).showNotification(true).debug(AdvanceConfig.getInstance().getDebug()).build());
            }
            AdvanceSetting.getInstance().hasKSInit = true;
            initSuccess = true;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        return initSuccess;
    }

    public static long getADID(SdkSupplier supplier) {
        long id2 = -1L;
        try {
            id2 = Long.parseLong(supplier.adspotid);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return id2;
    }

    private static String getCurrentProcessName(Context context) {
        try {
            int pid = Process.myPid();
            String currentProcessName = "";
            ActivityManager activityManager = (ActivityManager)context.getApplicationContext().getSystemService("activity");
            List runningAppProcesses = activityManager.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo processInfo : runningAppProcesses) {
                if (pid != processInfo.pid) continue;
                currentProcessName = processInfo.processName;
            }
            return currentProcessName;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return "";
        }
    }
}

