/*
 * Decompiled with CFR 0.152.
 */
package com.ksad.download;

import android.content.Intent;
import android.net.NetworkInfo;
import android.os.Environment;
import android.text.TextUtils;
import com.ksad.download.b;
import com.ksad.download.c;
import com.ksad.download.d.a;
import com.ksad.download.e;
import com.kwai.filedownloader.d.d;
import com.kwai.filedownloader.exception.FileDownloadNetworkPolicyException;
import com.kwai.filedownloader.i;
import com.kwai.filedownloader.q;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownloadTask
implements Serializable {
    private static final long serialVersionUID = -7092669850073266500L;
    private transient List<c> mDownloadListeners = new ArrayList<c>();
    private String mUrl;
    private int mAllowedNetworkTypes;
    private int mNotificationVisibility;
    private boolean mWakeInstallApk;
    private Serializable mTag;
    private Map<String, String> mRequestHeaders;
    private String mDestinationDir;
    private String mDestinationFileName;
    private boolean mUserPause;
    private boolean mIsCanceled = false;
    protected transient com.kwai.filedownloader.a mBaseDownloadTask;

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.mDownloadListeners = new ArrayList<c>();
    }

    public DownloadTask(DownloadRequest downloadRequest) {
        this.initDownloadRequestParams(downloadRequest);
        this.instantiateDownloadTask();
        this.initDownloadTaskParams();
    }

    public void submit() {
        try {
            if (!this.mBaseDownloadTask.c()) {
                this.mBaseDownloadTask.e();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void initDownloadRequestParams(DownloadRequest downloadRequest) {
        this.mWakeInstallApk = downloadRequest.mInstallAfterDownload;
        this.mUrl = downloadRequest.mDownloadUrl;
        this.mAllowedNetworkTypes = downloadRequest.mAllowedNetworkTypes;
        this.mNotificationVisibility = downloadRequest.mNotificationVisibility;
        this.mDestinationDir = downloadRequest.mDestinationDir;
        this.mDestinationFileName = downloadRequest.mDestinationFileName;
        this.mRequestHeaders = downloadRequest.mRequestHeaders;
        this.mTag = downloadRequest.mTag;
    }

    private void initDownloadTaskParams() {
        this.mBaseDownloadTask.a(this.mTag);
        this.mBaseDownloadTask.b((this.mAllowedNetworkTypes ^ 2) == 0);
        for (Map.Entry<String, String> entry : this.mRequestHeaders.entrySet()) {
            this.mBaseDownloadTask.b(entry.getKey());
            this.mBaseDownloadTask.a(entry.getKey(), entry.getValue());
        }
    }

    void instantiateDownloadTask() {
        this.mBaseDownloadTask = q.a().a(this.mUrl).a(true).a(3).a(TextUtils.isEmpty((CharSequence)this.mDestinationFileName) ? this.mDestinationDir : new File(this.mDestinationDir, this.mDestinationFileName).getPath(), TextUtils.isEmpty((CharSequence)this.mDestinationFileName)).a(new i(){

            @Override
            protected void a(com.kwai.filedownloader.a a2, String string, boolean bl2, int n2, int n3) {
                DownloadTask.this.onConnected(a2, string, bl2, n2, n3);
            }

            @Override
            protected void a(com.kwai.filedownloader.a a2) {
                DownloadTask.this.onStarted(a2);
            }

            @Override
            protected void a(com.kwai.filedownloader.a a2, int n2, int n3) {
                DownloadTask.this.onPending(a2, n2, n3);
            }

            @Override
            protected void b(com.kwai.filedownloader.a a2, int n2, int n3) {
                DownloadTask.this.onDownloading(a2, n2, n3);
            }

            @Override
            protected void b(com.kwai.filedownloader.a a2) {
                DownloadTask.this.onBlockCompleted(a2);
            }

            @Override
            protected void c(com.kwai.filedownloader.a a2) {
                DownloadTask.this.onCompleted(a2);
            }

            @Override
            protected void c(com.kwai.filedownloader.a a2, int n2, int n3) {
                DownloadTask.this.onPause(a2, n2, n3);
            }

            @Override
            protected void a(com.kwai.filedownloader.a a2, Throwable throwable) {
                DownloadTask.this.onError(a2, throwable);
            }

            @Override
            protected void d(com.kwai.filedownloader.a a2) {
                DownloadTask.this.onWarn(a2);
            }
        });
    }

    void cancel() {
        try {
            this.onCanceled(this.mBaseDownloadTask);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void pause() {
        this.mBaseDownloadTask.f();
        this.notifyDownloadProgress(this.mBaseDownloadTask, true);
    }

    void userPause() {
        this.mUserPause = true;
        this.pause();
    }

    int downLoadProgress() {
        long l2 = this.mBaseDownloadTask.s();
        int n2 = 0;
        if (l2 != 0L) {
            n2 = (int)(100.0f * (float)this.mBaseDownloadTask.q() / (float)l2);
        }
        if (n2 == 100 && !a.a(new File(this.mBaseDownloadTask.o()))) {
            n2 = 0;
        }
        return n2;
    }

    void installApk() {
        try {
            this.wakeInstallApk();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void resume(DownloadRequest downloadRequest) {
        if (!com.ksad.download.d.b.a(b.a())) {
            return;
        }
        if (downloadRequest != null) {
            this.initDownloadRequestParams(downloadRequest);
            this.initDownloadTaskParams();
        }
        this.mUserPause = false;
        if (!this.mBaseDownloadTask.c()) {
            try {
                if (d.a(this.mBaseDownloadTask.v())) {
                    this.mBaseDownloadTask.b();
                }
                this.submit();
                this.onResume(this.mBaseDownloadTask, this.mBaseDownloadTask.q(), this.mBaseDownloadTask.s());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    com.kwai.filedownloader.a unwrap() {
        return this.mBaseDownloadTask;
    }

    boolean isUserPause() {
        return this.mUserPause;
    }

    public boolean isRunning() {
        return this.mBaseDownloadTask.c();
    }

    public boolean isPaused() {
        return this.mBaseDownloadTask.v() == -2;
    }

    public boolean isError() {
        return this.mBaseDownloadTask.v() == -1;
    }

    public boolean isCompleted() {
        return this.mBaseDownloadTask.v() == -3;
    }

    public boolean isInvalid() {
        return this.mBaseDownloadTask.v() == 0;
    }

    public boolean isCanceled() {
        return this.mIsCanceled;
    }

    public int getId() {
        return this.mBaseDownloadTask.h();
    }

    public Object getTag() {
        return this.mBaseDownloadTask.z();
    }

    public String getTargetFilePath() {
        return this.mBaseDownloadTask.o();
    }

    public String getFilename() {
        return this.mBaseDownloadTask.n();
    }

    public String getPath() {
        return this.mBaseDownloadTask.l();
    }

    public int getSpeed() {
        return this.mBaseDownloadTask.u();
    }

    public int getSmallFileSoFarBytes() {
        return this.mBaseDownloadTask.q();
    }

    public int getStatus() {
        return this.mBaseDownloadTask.v();
    }

    public long getStatusUpdateTime() {
        return this.mBaseDownloadTask.w();
    }

    public int getSmallFileTotalBytes() {
        return this.mBaseDownloadTask.s();
    }

    public int getAllowedNetworkTypes() {
        return this.mAllowedNetworkTypes;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getNotificationVisibility() {
        return this.mNotificationVisibility;
    }

    public String getDestinationDir() {
        return this.mDestinationDir;
    }

    private void onDownloading(com.kwai.filedownloader.a a2, int n2, int n3) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.b(this, n2, n3);
            }
            this.notifyDownloadProgress(this.mBaseDownloadTask, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onLowStorage(com.kwai.filedownloader.a a2) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.f(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onConnected(com.kwai.filedownloader.a a2, String string, boolean bl2, int n2, int n3) {
        long l2 = n3;
        try {
            l2 = new File(this.mDestinationDir).exists() ? a.a(this.mDestinationDir) : a.a(Environment.getExternalStorageDirectory().getPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (l2 < (long)n3) {
            Intent intent = new Intent(com.kwad.sdk.core.download.a.n);
            intent.putExtra("download.intent.action.EXTRA_TASK_ID", a2.h());
            b.a().sendBroadcast(intent);
            this.onLowStorage(a2);
            return;
        }
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.a(this, string, bl2, n2, n3);
            }
            this.notifyDownloadProgress(a2, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onBlockCompleted(com.kwai.filedownloader.a a2) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.a(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onCompleted(com.kwai.filedownloader.a a2) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.b(this);
            }
            this.notifyDownloadCompleted(a2);
            if (this.mWakeInstallApk) {
                this.wakeInstallApk();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onPending(com.kwai.filedownloader.a a2, int n2, int n3) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.a(this, n2, n3);
            }
            this.notifyDownloadPending(a2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onStarted(com.kwai.filedownloader.a a2) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.c(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onWarn(com.kwai.filedownloader.a a2) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.d(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void wakeInstallApk() {
        b.a(this.mBaseDownloadTask.o());
    }

    private void onPause(com.kwai.filedownloader.a a2, int n2, int n3) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.c(this, n2, n3);
            }
            this.notifyDownloadProgress(a2, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onError(com.kwai.filedownloader.a a2, Throwable throwable) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.a(this, throwable);
            }
            this.notifyDownloadError(a2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onCanceled(com.kwai.filedownloader.a a2) {
        try {
            this.mIsCanceled = true;
            for (c c2 : this.mDownloadListeners) {
                c2.e(this);
            }
            a2.g();
            e.a().a(this.getId());
            q.a().a(this.getId(), this.mBaseDownloadTask.o());
            this.releaseDownloadTask();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void releaseDownloadTask() {
        this.mBaseDownloadTask.a((i)null);
        this.clearListener();
    }

    private void onResume(com.kwai.filedownloader.a a2, int n2, int n3) {
        try {
            for (c c2 : this.mDownloadListeners) {
                c2.d(this, n2, n3);
            }
            this.notifyDownloadProgress(a2, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void notifyDownloadPending(com.kwai.filedownloader.a a2) {
        if ((this.mNotificationVisibility & 2) != 0) {
            e.a().a(this);
        }
    }

    private void notifyDownloadCompleted(com.kwai.filedownloader.a a2) {
        if ((this.mNotificationVisibility & 2) != 0) {
            e.a().c(this);
        }
    }

    private void notifyDownloadProgress(com.kwai.filedownloader.a a2, boolean bl2) {
        if (a2.s() == 0 && a2.q() == 0) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)a2.n())) {
            return;
        }
        if ((this.mNotificationVisibility & 1) != 0) {
            e.a().a(this, bl2);
        }
    }

    private void notifyDownloadError(com.kwai.filedownloader.a a2) {
        if ((this.mNotificationVisibility & 1) != 0) {
            e.a().b(this);
        }
    }

    public void addListener(c c2) {
        if (c2 != null && !this.mDownloadListeners.contains(c2)) {
            this.mDownloadListeners.add(c2);
        }
    }

    public void removeListener(c c2) {
        if (c2 != null) {
            this.mDownloadListeners.remove(c2);
        }
    }

    public void clearListener() {
        this.mDownloadListeners.clear();
    }

    public boolean isErrorBecauseWifiRequired() {
        return this.mBaseDownloadTask.E() && this.isError() && this.mBaseDownloadTask.y() instanceof FileDownloadNetworkPolicyException;
    }

    public void setAllowedNetworkTypes(int n2) {
        this.mAllowedNetworkTypes = n2;
        this.mBaseDownloadTask.b((this.mAllowedNetworkTypes ^ 2) == 0);
    }

    public static class DownloadRequest
    implements Serializable {
        private static final long serialVersionUID = -3638290207248829674L;
        private final Map<String, String> mRequestHeaders = new HashMap<String, String>();
        private String mDownloadUrl;
        private String mDestinationDir;
        private String mDestinationFileName;
        private Serializable mTag;
        private boolean mInstallAfterDownload = true;
        @Deprecated
        private boolean mIsPhotoAdDownloadRequest = false;
        private int mAllowedNetworkTypes = 3;
        private int mNotificationVisibility = 0;

        public DownloadRequest(String string) {
            if (!b.b().exists()) {
                b.b().mkdirs();
            }
            this.mDestinationDir = b.b().getPath();
            this.mDownloadUrl = string;
            NetworkInfo networkInfo = com.ksad.download.d.b.c(b.a());
            this.mAllowedNetworkTypes = networkInfo != null && networkInfo.getType() == 0 ? 3 : 2;
        }

        public String getDownloadUrl() {
            return this.mDownloadUrl;
        }

        public String getDestinationDir() {
            return this.mDestinationDir;
        }

        public String getDestinationFileName() {
            return this.mDestinationFileName;
        }

        public DownloadRequest setDestinationDir(String string) {
            this.mDestinationDir = string;
            return this;
        }

        public DownloadRequest setDestinationFileName(String string) {
            this.mDestinationFileName = string;
            return this;
        }

        public DownloadRequest setTag(Serializable serializable) {
            this.mTag = serializable;
            return this;
        }

        public Serializable getTag() {
            return this.mTag;
        }

        public boolean isPhotoAdDownloadRequest() {
            return this.mIsPhotoAdDownloadRequest;
        }

        public void setIsPhotoAdDownloadRequest() {
            this.mIsPhotoAdDownloadRequest = true;
        }

        public DownloadRequest addRequestHeader(String string, String string2) {
            if (string == null) {
                throw new NullPointerException("header cannot be null");
            }
            if (string.contains(":")) {
                throw new IllegalArgumentException("header may not contain ':'");
            }
            if (string2 == null) {
                string2 = "";
            }
            this.mRequestHeaders.put(string, string2);
            return this;
        }

        public DownloadRequest setInstallAfterDownload(boolean bl2) {
            this.mInstallAfterDownload = bl2;
            return this;
        }

        public DownloadRequest setNotificationVisibility(int n2) {
            this.mNotificationVisibility = n2;
            return this;
        }

        public DownloadRequest setAllowedNetworkTypes(int n2) {
            this.mAllowedNetworkTypes = n2;
            return this;
        }

        public int getAllowedNetworkTypes() {
            return this.mAllowedNetworkTypes;
        }
    }
}

