/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kwad.sdk.api.KsLoadManager;
import com.kwad.sdk.api.SdkConfig;
import com.kwad.sdk.api.b;
import com.kwad.sdk.api.core.IKsAdSDK;
import com.kwad.sdk.api.core.KsAdSdkApi;
import com.kwad.sdk.api.loader.Loader;
import com.kwad.sdk.api.loader.Wrapper;
import com.kwad.sdk.api.loader.c;
import com.kwad.sdk.api.loader.q;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.atomic.AtomicBoolean;

@KsAdSdkApi
@Keep
public class KsAdSDK {
    @Keep
    private static IKsAdSDK sSdk = null;
    private static final AtomicBoolean sInited = new AtomicBoolean(false);
    private static String sAppTag;

    public static void setThemeMode(int n2) {
        if (sSdk != null) {
            sSdk.setThemeMode(n2);
        }
    }

    @KsAdSdkApi
    @Keep
    public static synchronized boolean init(Context context, SdkConfig sdkConfig) {
        try {
            context = c.a(context);
            Loader.get().init(context);
            sSdk = Loader.get().getKsAdSDKImpl();
            if (sSdk != null) {
                sSdk.setApiVersion("3.3.9");
                sSdk.setApiVersionCode(3030900);
                sSdk.setAppTag(sAppTag);
                sSdk.init(Wrapper.wrapContextIfNeed(context), sdkConfig);
            }
            sInited.set(sSdk != null);
            if (sdkConfig != null) {
                q.a(context, "sdkconfig", sdkConfig.toJson());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            sInited.set(false);
        }
        if (b.a.booleanValue()) {
            Loader.get().checkUpdate();
        }
        return sInited.get();
    }

    @KsAdSdkApi
    @Keep
    public static boolean isDebugLogEnable() {
        if (sSdk != null) {
            return sSdk.isDebugLogEnable();
        }
        return false;
    }

    @KsAdSdkApi
    @Keep
    public static String getAppId() {
        if (sSdk != null) {
            return sSdk.getAppId();
        }
        return null;
    }

    @KsAdSdkApi
    @Keep
    public static String getAppName() {
        if (sSdk != null) {
            return sSdk.getAppName();
        }
        return null;
    }

    @KsAdSdkApi
    @Nullable
    @Keep
    public static Context getContext() {
        if (sSdk != null) {
            return sSdk.getContext();
        }
        return null;
    }

    @KsAdSdkApi
    @NonNull
    @Keep
    public static KsLoadManager getLoadManager() {
        if (sSdk != null) {
            return sSdk.getAdManager();
        }
        return null;
    }

    @KsAdSdkApi
    @Keep
    public static void unInit() {
        if (sSdk != null) {
            sSdk.unInit();
        }
        sSdk = null;
    }

    @KsAdSdkApi
    @Keep
    public static String getSDKVersion() {
        return "3.3.9";
    }

    @KsAdSdkApi
    @Keep
    public static void deleteCache() {
        if (sSdk != null) {
            sSdk.deleteCache();
        }
    }

    @KsAdSdkApi
    @Keep
    public static String getDid() {
        if (sSdk != null) {
            return sSdk.getDid();
        }
        return null;
    }

    @KsAdSdkApi
    @Keep
    public static void setAppTag(String string2) {
        if (sSdk != null) {
            sSdk.setAppTag(string2);
        } else {
            sAppTag = string2;
        }
    }

    @KsAdSdkApi
    @Keep
    public static void resumeCurrentPlayer() {
        if (sSdk != null) {
            sSdk.resumeCurrentPlayer();
        }
    }

    @KsAdSdkApi
    @Keep
    public static void pauseCurrentPlayer() {
        if (sSdk != null) {
            sSdk.pauseCurrentPlayer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Keep
    public static @interface KsThemeModeType {
        public static final int NORMAL = 0;
        public static final int NIGHT = 1;
    }
}

