/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import android.widget.RemoteViews;
import com.kwad.sdk.api.core.ICompletedRemoteView;
import com.kwad.sdk.api.core.IProgressRemoteView;
import com.kwad.sdk.api.core.KsAdSdkDynamicApi;
import com.kwad.sdk.api.core.ResContext;
import com.kwad.sdk.api.core.ResUtil;

@KsAdSdkDynamicApi
@Keep
public class RemoteViewBuilder {
    private static Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int n2 = !drawable2.getBounds().isEmpty() ? drawable2.getBounds().width() : drawable2.getIntrinsicWidth();
        int n3 = !drawable2.getBounds().isEmpty() ? drawable2.getBounds().height() : drawable2.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)(n2 <= 0 ? 1 : n2), (int)(n3 <= 0 ? 1 : n3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private static Bitmap getBitmap(Context context, int n2) {
        Drawable drawable2 = context.getResources().getDrawable(n2);
        return RemoteViewBuilder.drawableToBitmap(drawable2);
    }

    @KsAdSdkDynamicApi
    @Keep
    public static IProgressRemoteView createProgressView(Context context) {
        return new ProgressRemoteViewImpl(context);
    }

    @KsAdSdkDynamicApi
    @Keep
    public static ICompletedRemoteView createCompletedView(Context context) {
        return new CompletedRemoteViewImpl(context);
    }

    private static class CompletedRemoteViewImpl
    implements ICompletedRemoteView {
        private final RemoteViews mRemoteViews;
        private final Context mContext;
        private final Context mOriginContext;

        private CompletedRemoteViewImpl(Context context) {
            this.mContext = context;
            this.mOriginContext = context instanceof ResContext ? ((ResContext)context).getDelegatedContext() : context;
            this.mRemoteViews = new RemoteViews(this.mOriginContext.getPackageName(), ResUtil.getLayoutId(this.mOriginContext, "ksad_notification_download_completed"));
        }

        @Override
        public void setIcon(Bitmap bitmap) {
            this.mRemoteViews.setImageViewBitmap(ResUtil.getId(this.mOriginContext, "ksad_download_icon"), bitmap);
        }

        @Override
        public void setIcon(int n2) {
            this.setIcon(RemoteViewBuilder.getBitmap(this.mContext, n2));
        }

        @Override
        public void setName(String string) {
            this.mRemoteViews.setTextViewText(ResUtil.getId(this.mOriginContext, "ksad_download_name"), (CharSequence)string);
        }

        @Override
        public void setStatus(String string) {
            this.mRemoteViews.setTextViewText(ResUtil.getId(this.mOriginContext, "ksad_download_status"), (CharSequence)string);
        }

        @Override
        public void setSize(String string) {
            this.mRemoteViews.setTextViewText(ResUtil.getId(this.mOriginContext, "ksad_download_size"), (CharSequence)string);
        }

        @Override
        public void setInstallText(String string) {
            this.mRemoteViews.setTextViewText(ResUtil.getId(this.mOriginContext, "ksad_download_install"), (CharSequence)string);
        }

        @Override
        public RemoteViews build() {
            return this.mRemoteViews;
        }
    }

    private static class ProgressRemoteViewImpl
    implements IProgressRemoteView {
        private final RemoteViews mRemoteViews;
        private final Context mContext;
        private final Context mOriginContext;

        private ProgressRemoteViewImpl(Context context) {
            this.mContext = context;
            this.mOriginContext = context instanceof ResContext ? ((ResContext)context).getDelegatedContext() : context;
            this.mRemoteViews = new RemoteViews(this.mOriginContext.getPackageName(), ResUtil.getLayoutId(this.mOriginContext, "ksad_notification_download_progress"));
        }

        @Override
        public void setIcon(Bitmap bitmap) {
            this.mRemoteViews.setImageViewBitmap(ResUtil.getId(this.mOriginContext, "ksad_download_icon"), bitmap);
        }

        @Override
        public void setIcon(int n2) {
            this.setIcon(RemoteViewBuilder.getBitmap(this.mContext, n2));
        }

        @Override
        public void setName(String string) {
            this.mRemoteViews.setTextViewText(ResUtil.getId(this.mOriginContext, "ksad_download_name"), (CharSequence)string);
        }

        @Override
        public void setStatus(String string) {
            this.mRemoteViews.setTextViewText(ResUtil.getId(this.mOriginContext, "ksad_download_status"), (CharSequence)string);
        }

        @Override
        public void setProgress(int n2, int n3, boolean bl2) {
            this.mRemoteViews.setProgressBar(ResUtil.getId(this.mOriginContext, "ksad_download_progress"), n2, n3, bl2);
        }

        @Override
        public void setSize(String string) {
            this.mRemoteViews.setTextViewText(ResUtil.getId(this.mOriginContext, "ksad_download_size"), (CharSequence)string);
        }

        @Override
        public void setPercentNum(String string) {
            this.mRemoteViews.setTextViewText(ResUtil.getId(this.mOriginContext, "ksad_download_percent_num"), (CharSequence)string);
        }

        @Override
        public RemoteViews build() {
            return this.mRemoteViews;
        }
    }
}

