/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.core.lifecycle;

import android.arch.lifecycle.GenericLifecycleObserver;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.support.annotation.Keep;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import com.kwad.sdk.api.core.lifecycle.KsGenericLifecycleObserver;
import com.kwad.sdk.api.core.lifecycle.KsLifecycleObserver;

public class KsLifecycle {
    private Lifecycle mBase;

    public KsLifecycle(Lifecycle lifecycle) {
        this.mBase = lifecycle;
    }

    @MainThread
    public void addObserver(final @NonNull KsLifecycleObserver ksLifecycleObserver) {
        if (ksLifecycleObserver instanceof KsGenericLifecycleObserver) {
            GenericLifecycleObserver genericLifecycleObserver = new GenericLifecycleObserver(){

                public void onStateChanged(LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
                    ((KsGenericLifecycleObserver)ksLifecycleObserver).onStateChanged(KsLifeEvent.createfrom(event));
                }
            };
            ksLifecycleObserver.setBase((LifecycleObserver)genericLifecycleObserver);
            this.mBase.addObserver((LifecycleObserver)genericLifecycleObserver);
        }
    }

    @MainThread
    public void removeObserver(@NonNull KsLifecycleObserver ksLifecycleObserver) {
        this.mBase.removeObserver(ksLifecycleObserver.getBase());
    }

    @MainThread
    public KsLifeState getCurrentState() {
        return KsLifeState.createFrom(this.mBase.getCurrentState());
    }

    public static enum KsLifeState {
        DESTROYED(Lifecycle.State.DESTROYED),
        INITIALIZED(Lifecycle.State.DESTROYED),
        CREATED(Lifecycle.State.DESTROYED),
        STARTED(Lifecycle.State.DESTROYED),
        RESUMED(Lifecycle.State.DESTROYED);

        Lifecycle.State mReal;

        private KsLifeState(Lifecycle.State state) {
            this.mReal = state;
        }

        public boolean isAtLeast(@NonNull KsLifeState ksLifeState) {
            return this.compareTo(ksLifeState) >= 0;
        }

        public static KsLifeState createFrom(Lifecycle.State state) {
            for (KsLifeState ksLifeState : KsLifeState.values()) {
                if (ksLifeState.mReal != state) continue;
                return ksLifeState;
            }
            return null;
        }
    }

    @Keep
    public static enum KsLifeEvent {
        ON_CREATE(Lifecycle.Event.ON_CREATE),
        ON_START(Lifecycle.Event.ON_START),
        ON_RESUME(Lifecycle.Event.ON_RESUME),
        ON_PAUSE(Lifecycle.Event.ON_PAUSE),
        ON_STOP(Lifecycle.Event.ON_STOP),
        ON_DESTROY(Lifecycle.Event.ON_DESTROY),
        ON_ANY(Lifecycle.Event.ON_ANY);

        Lifecycle.Event mRealValue;

        private KsLifeEvent(Lifecycle.Event event) {
            this.mRealValue = event;
        }

        @Keep
        public Lifecycle.Event getReal() {
            return this.mRealValue;
        }

        public static KsLifeEvent createfrom(Lifecycle.Event event) {
            for (KsLifeEvent ksLifeEvent : KsLifeEvent.values()) {
                if (ksLifeEvent.getReal() != event) continue;
                return ksLifeEvent;
            }
            return null;
        }
    }
}

