/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.loader;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.v7.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import com.kwad.sdk.api.core.ResContext;
import com.kwad.sdk.api.loader.Loader;
import com.kwad.sdk.api.loader.l;
import com.kwad.sdk.api.loader.m;
import com.kwad.sdk.api.loader.n;
import java.util.Map;
import java.util.WeakHashMap;

@Keep
public class Wrapper {
    private static Map<Context, Context> sResContextCache = new WeakHashMap<Context, Context>();

    @Keep
    @Nullable
    public static Context wrapContextIfNeed(@Nullable Context context) {
        if (!Loader.get().isExternalLoaded()) {
            return context;
        }
        if (context == null) {
            return null;
        }
        if (context instanceof ResContext) {
            return context;
        }
        if (context instanceof android.view.ContextThemeWrapper) {
            Object object = sResContextCache.get(context);
            if (object == null) {
                object = new l((android.view.ContextThemeWrapper)context);
                sResContextCache.put(context, (Context)object);
            }
            return object;
        }
        if (context instanceof ContextThemeWrapper) {
            Object object = sResContextCache.get(context);
            if (object == null) {
                object = new m((ContextThemeWrapper)context);
                sResContextCache.put(context, (Context)object);
            }
            return object;
        }
        if (context instanceof ContextWrapper) {
            Object object = sResContextCache.get(context);
            if (object == null) {
                object = new n(context);
                sResContextCache.put(context, (Context)object);
            }
            return object;
        }
        Object object = sResContextCache.get(context);
        if (object == null) {
            object = new n(context);
            sResContextCache.put(context, (Context)object);
        }
        return object;
    }

    @Keep
    public static LayoutInflater wrapInflaterIfNeed(LayoutInflater layoutInflater) {
        if (!Loader.get().isExternalLoaded()) {
            return layoutInflater;
        }
        Context context = layoutInflater.getContext();
        if (!(context instanceof ResContext)) {
            Context context2 = Wrapper.wrapContextIfNeed(context);
            if (context2 instanceof ResContext) {
                return layoutInflater.cloneInContext(context2);
            }
            return layoutInflater;
        }
        return layoutInflater;
    }

    @Keep
    public static Context unwrapContextIfNeed(Context context) {
        ResContext resContext = null;
        Context context2 = context;
        if (context instanceof ResContext) {
            resContext = (ResContext)context;
        }
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return context;
            }
            if (context instanceof ResContext) {
                resContext = (ResContext)context;
                context = resContext.getDelegatedContext();
                continue;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (resContext != null) {
            return resContext.getDelegatedContext();
        }
        return context2;
    }
}

