/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.proxy;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import com.kwad.sdk.api.core.fragment.KsFragment;
import com.kwad.sdk.api.core.fragment.KsFragmentActivity;
import com.kwad.sdk.api.loader.Loader;
import com.kwad.sdk.api.loader.Wrapper;
import com.kwad.sdk.api.proxy.IFragmentActivityProxy;

public abstract class BaseProxyFragmentActivity
extends KsFragmentActivity {
    private IFragmentActivityProxy mDelegate;

    @NonNull
    protected abstract IFragmentActivityProxy getDelegate(Context var1);

    protected void attachBaseContext(Context context) {
        super.attachBaseContext(Wrapper.wrapContextIfNeed(context));
        this.mDelegate = this.getDelegate(context);
        this.mDelegate.setProxyFragmentActivity(this);
        this.mDelegate.setActivity((Activity)this);
    }

    @Override
    public void onAttachFragment(KsFragment ksFragment) {
        super.onAttachFragment(ksFragment);
        this.mDelegate.onAttachFragment(ksFragment);
    }

    protected void onCreate(@Nullable Bundle bundle) {
        this.mDelegate.onPreCreate(bundle);
        super.onCreate(bundle);
        this.mDelegate.onCreate(bundle);
    }

    public Intent getIntent() {
        ClassLoader classLoader = Loader.get().getExternalClassLoader();
        if (classLoader != null) {
            Intent intent = super.getIntent();
            intent.setExtrasClassLoader(classLoader);
            return intent;
        }
        return super.getIntent();
    }

    protected void onPostCreate(@Nullable Bundle bundle) {
        super.onPostCreate(bundle);
        this.mDelegate.onPostCreate(bundle);
    }

    protected void onStart() {
        this.mDelegate.onPreStart();
        super.onStart();
        this.mDelegate.onStart();
    }

    protected void onResume() {
        this.mDelegate.onPreResume();
        super.onResume();
        this.mDelegate.onResume();
    }

    protected void onPostResume() {
        super.onPostResume();
        this.mDelegate.onPostResume();
    }

    protected void onPause() {
        this.mDelegate.onPrePause();
        super.onPause();
        this.mDelegate.onPause();
    }

    protected void onStop() {
        this.mDelegate.onPreStop();
        super.onStop();
        this.mDelegate.onStop();
    }

    @Override
    protected void onDestroy() {
        this.mDelegate.onPreDestroy();
        super.onDestroy();
        this.mDelegate.onDestroy();
    }

    protected void onRestart() {
        super.onRestart();
        this.mDelegate.onRestart();
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        super.onActivityResult(n2, n3, intent);
        this.mDelegate.onActivityResult(n2, n3, intent);
    }

    protected void onApplyThemeResource(Resources.Theme theme, int n2, boolean bl2) {
        super.onApplyThemeResource(theme, n2, bl2);
        this.mDelegate.onApplyThemeResource(theme, n2, bl2);
    }

    protected void onChildTitleChanged(Activity activity, CharSequence charSequence) {
        super.onChildTitleChanged(activity, charSequence);
        this.mDelegate.onChildTitleChanged(activity, charSequence);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.mDelegate.onNewIntent(intent);
    }

    protected void onRestoreInstanceState(@NonNull Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        this.mDelegate.onRestoreInstanceState(bundle);
    }

    protected void onSaveInstanceState(@NonNull Bundle bundle) {
        this.mDelegate.onPreSaveInstanceState(bundle);
        super.onSaveInstanceState(bundle);
        this.mDelegate.onSaveInstanceState(bundle);
    }

    protected void onTitleChanged(CharSequence charSequence, int n2) {
        super.onTitleChanged(charSequence, n2);
        this.mDelegate.onTitleChanged(charSequence, n2);
    }

    protected void onUserLeaveHint() {
        super.onUserLeaveHint();
        this.mDelegate.onUserLeaveHint();
    }

    public void onBackPressed() {
        this.mDelegate.onBackPressed();
    }

    public void superOnBackPressed() {
        super.onBackPressed();
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        return this.mDelegate.onKeyDown(n2, keyEvent);
    }

    public boolean superOnKeyDown(int n2, KeyEvent keyEvent) {
        return super.onKeyDown(n2, keyEvent);
    }

    public boolean onKeyLongPress(int n2, KeyEvent keyEvent) {
        return this.mDelegate.onKeyLongPress(n2, keyEvent);
    }

    public boolean superOnKeyLongPress(int n2, KeyEvent keyEvent) {
        return super.onKeyLongPress(n2, keyEvent);
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.mDelegate.onKeyUp(n2, keyEvent);
    }

    public boolean superOnKeyUp(int n2, KeyEvent keyEvent) {
        return super.onKeyUp(n2, keyEvent);
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mDelegate.onConfigurationChanged(configuration);
    }

    public void startActivity(Intent intent) {
        if (intent != null) {
            intent.putExtra("key_start_time", SystemClock.uptimeMillis());
        }
        super.startActivity(intent);
    }
}

