/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.api.proxy;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kwad.sdk.api.loader.Loader;
import com.kwad.sdk.api.loader.Wrapper;
import com.kwad.sdk.api.proxy.IServiceProxy;

public abstract class BaseProxyService
extends Service {
    private IServiceProxy mDelegate;

    @NonNull
    protected abstract IServiceProxy getDelegate(Context var1);

    protected void attachBaseContext(Context context) {
        super.attachBaseContext(Wrapper.wrapContextIfNeed(context));
        this.mDelegate = this.getDelegate(context);
        assert (this.mDelegate != null);
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        ClassLoader classLoader = Loader.get().getExternalClassLoader();
        if (classLoader != null) {
            intent.setExtrasClassLoader(classLoader);
        }
        return this.mDelegate.onBind(this, intent);
    }

    public boolean onUnbind(Intent intent) {
        return this.mDelegate.onUnbind(this, intent);
    }

    public boolean superOnUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public void onCreate() {
        super.onCreate();
        this.mDelegate.onCreate(this);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mDelegate.onDestroy(this);
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
        ClassLoader classLoader = Loader.get().getExternalClassLoader();
        if (classLoader != null) {
            intent.setExtrasClassLoader(classLoader);
        }
        this.mDelegate.onRebind(this, intent);
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        ClassLoader classLoader = Loader.get().getExternalClassLoader();
        if (classLoader != null && intent != null) {
            intent.setExtrasClassLoader(classLoader);
        }
        return this.mDelegate.onStartCommand(this, intent, n2, n3);
    }

    public int superOnStartCommand(Intent intent, int n2, int n3) {
        return super.onStartCommand(intent, n2, n3);
    }
}

