/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.collector;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kwad.sdk.collector.h;
import com.kwad.sdk.collector.model.c;
import com.kwad.sdk.collector.model.d;
import com.kwad.sdk.core.b;
import com.kwad.sdk.core.d.a;
import com.kwad.sdk.core.network.BaseResultData;
import com.kwad.sdk.utils.q;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppStatusRules
extends BaseResultData
implements b {
    private static final long serialVersionUID = 3026909056348431027L;
    public static final long DEFAULT_START_TIME = 86400000L;
    public static final long DEFAULT_GRANULARITY = 60000L;
    public static String SUFFIX_ALL_CHILDREN = "/*";
    public static String SUFFIX_ALL_FILE = "*";
    private AppStatusInfo data = new AppStatusInfo();

    @NonNull
    public static AppStatusRules createFromJson(String string) {
        AppStatusRules appStatusRules = new AppStatusRules();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return appStatusRules;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            appStatusRules.parseJson(jSONObject);
        }
        catch (Exception exception) {
            a.a(exception);
        }
        return appStatusRules;
    }

    public static boolean isAppStatusTargetNotEmpty(AppStatusRules appStatusRules) {
        if (appStatusRules == null) {
            return false;
        }
        boolean bl2 = appStatusRules.targetNotEmpty();
        List<Strategy> list = appStatusRules.obtainNamedStrategyList();
        boolean bl3 = list != null && list.size() > 0;
        return bl2 || bl3;
    }

    public static boolean isUploadTargetNotEmpty(AppStatusRules appStatusRules) {
        if (appStatusRules == null) {
            return false;
        }
        List<d> list = appStatusRules.getUploadTargets();
        return list != null && list.size() > 0;
    }

    public void initStatus(Context context) {
        ArrayList<Strategy> arrayList = this.getAllStrategy();
        for (Strategy strategy : arrayList) {
            boolean bl2 = h.a(context, strategy);
            strategy.setNeedLaunch(bl2);
        }
    }

    public ArrayList<Strategy> getAllStrategy() {
        ArrayList<Strategy> arrayList = new ArrayList<Strategy>();
        if (this.data.strategy != null) {
            arrayList.add(this.data.strategy);
        }
        if (this.data.namedStrategy != null) {
            arrayList.addAll(this.data.namedStrategy);
        }
        return arrayList;
    }

    public Strategy obtainDefaultStrategy() {
        if (this.data == null) {
            return null;
        }
        return this.data.strategy;
    }

    public boolean targetNotEmpty() {
        if (this.data == null || this.data.target == null) {
            return false;
        }
        ArrayList arrayList = this.data.target;
        return arrayList.size() > 0;
    }

    public List<Strategy> obtainNamedStrategyList() {
        if (this.data == null) {
            return null;
        }
        return this.data.namedStrategy;
    }

    public long obtainDefaultScanInterval() {
        if (this.data == null || this.data.getStrategy() == null) {
            return 0L;
        }
        long l2 = this.data.getStrategy().getScanInterval();
        if (l2 < 0L) {
            l2 = 0L;
        }
        return l2 * 1000L;
    }

    @Nullable
    public List<d> getUploadTargets() {
        if (this.data == null) {
            return null;
        }
        return this.data.uploadTarget;
    }

    public long obtainUploadConfigFileMaxSize() {
        long l2 = 102400L;
        if (this.data != null && this.data.uploadConfig != null) {
            l2 = ((AppStatusInfo)this.data).uploadConfig.fileMaxSize;
        }
        return l2;
    }

    @Override
    public void parseJson(@Nullable JSONObject jSONObject) {
        super.parseJson(jSONObject);
        if (jSONObject == null) {
            return;
        }
        try {
            String string = jSONObject.optString("data");
            String string2 = com.kwad.sdk.core.b.d.b(string);
            JSONObject jSONObject2 = new JSONObject(string2);
            this.data.parseJson(jSONObject2);
        }
        catch (Exception exception) {
            a.a(exception);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jSONObject = super.toJson();
        q.a(jSONObject, "data", this.data);
        return jSONObject;
    }

    public static class UploadConfig
    extends com.kwad.sdk.core.response.a.a
    implements b,
    Serializable {
        private static final long serialVersionUID = 8541150615721258815L;
        public static final int DEFAULT_FILE_MAX_SIZE = 102400;
        public long fileMaxSize = 102400L;

        @Override
        public void afterParseJson(@Nullable JSONObject jSONObject) {
            super.afterParseJson(jSONObject);
            if (this.fileMaxSize < 0L) {
                this.fileMaxSize = 102400L;
            }
        }
    }

    public static class Strategy
    implements b,
    Serializable {
        private static final long serialVersionUID = -1387498537762043285L;
        public static Strategy LOCAL_DEFAULT = new Strategy();
        private long startTime = 86400000L;
        private long scanInterval;
        private long historyGranularity = 60000L;
        private String name = null;
        private long minLaunchInterval;
        private HashMap<String, d> targetMap = new HashMap();
        private boolean needLaunch = true;
        private long needSaveLaunchTime = -1L;

        public static ArrayList<Strategy> createFromJSONArray(JSONArray jSONArray) {
            ArrayList<Strategy> arrayList = new ArrayList<Strategy>();
            if (jSONArray == null || jSONArray.length() == 0) {
                return arrayList;
            }
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = null;
                try {
                    jSONObject = jSONArray.getJSONObject(i2);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (jSONObject == null) continue;
                Strategy strategy = new Strategy();
                strategy.parseJson(jSONObject);
                arrayList.add(strategy);
            }
            return arrayList;
        }

        public long getStartTimeWithMS() {
            return this.startTime * 1000L;
        }

        public void setStartTime(long l2) {
            this.startTime = l2;
        }

        public long getNeedSaveLaunchTime() {
            return this.needSaveLaunchTime;
        }

        public void setNeedSaveLaunchTime(long l2) {
            this.needSaveLaunchTime = l2;
        }

        public long getScanInterval() {
            return this.scanInterval;
        }

        public void setScanInterval(long l2) {
            this.scanInterval = l2;
        }

        public long getHistoryGranularity() {
            return this.historyGranularity;
        }

        public void setHistoryGranularity(long l2) {
            this.historyGranularity = l2;
        }

        public boolean isNeedLaunch() {
            return this.needLaunch;
        }

        public void setNeedLaunch(boolean bl2) {
            this.needLaunch = bl2;
        }

        public String getName() {
            return this.name;
        }

        public long getMinLaunchIntervalWithMS() {
            return this.minLaunchInterval * 1000L;
        }

        public ArrayList<d> getTarget() {
            return new ArrayList<d>(this.targetMap.values());
        }

        public Set<String> getTargetPackages() {
            Collection<d> collection = this.targetMap.values();
            HashSet<String> hashSet = new HashSet<String>();
            for (d d2 : collection) {
                hashSet.add(c.a(d2));
            }
            return hashSet;
        }

        public void removeTargetsByPackage(Collection<String> collection) {
            for (String string : collection) {
                this.targetMap.remove(string);
            }
        }

        public void setTarget(ArrayList<d> arrayList) {
            if (arrayList != null) {
                for (d d2 : arrayList) {
                    this.targetMap.put(c.a(d2), d2);
                }
            } else {
                this.targetMap.clear();
            }
        }

        @Override
        public void parseJson(@Nullable JSONObject jSONObject) {
            if (jSONObject == null) {
                return;
            }
            try {
                this.startTime = jSONObject.optLong("startTime");
                this.scanInterval = jSONObject.optLong("scanInterval");
                int n2 = jSONObject.optInt("historyGranularity");
                if (n2 > 0) {
                    this.historyGranularity = n2 * 1000;
                }
                this.name = jSONObject.optString("name");
                this.minLaunchInterval = jSONObject.optLong("minLaunchInterval");
                JSONArray jSONArray = jSONObject.optJSONArray("target");
                ArrayList<d> arrayList = c.a(jSONArray);
                this.setTarget(arrayList);
            }
            catch (Exception exception) {
                a.a(exception);
            }
        }

        @Override
        public JSONObject toJson() {
            JSONObject jSONObject = new JSONObject();
            q.a(jSONObject, "startTime", this.startTime);
            q.a(jSONObject, "scanInterval", this.scanInterval);
            long l2 = this.historyGranularity / 1000L;
            q.a(jSONObject, "historyGranularity", l2);
            q.a(jSONObject, "name", this.name);
            ArrayList<d> arrayList = this.getTarget();
            q.a(jSONObject, "target", arrayList);
            q.a(jSONObject, "minLaunchInterval", this.minLaunchInterval);
            return jSONObject;
        }

        static {
            LOCAL_DEFAULT.setStartTime(86400000L);
            LOCAL_DEFAULT.setHistoryGranularity(60000L);
        }
    }

    private static class AppStatusInfo
    implements b,
    Serializable {
        private static final long serialVersionUID = -2403646317801179050L;
        private Strategy strategy = new Strategy();
        private ArrayList<d> target = new ArrayList();
        private ArrayList<Strategy> namedStrategy = new ArrayList();
        private ArrayList<d> uploadTarget = new ArrayList();
        private UploadConfig uploadConfig = new UploadConfig();

        private AppStatusInfo() {
        }

        public Strategy getStrategy() {
            return this.strategy;
        }

        public void setStrategy(Strategy strategy) {
            this.strategy = strategy;
        }

        public ArrayList<d> getTarget() {
            return this.target;
        }

        public void setTarget(ArrayList<d> arrayList) {
            this.target = arrayList;
        }

        private void duplicateTarget() {
            Set<String> set = this.strategy.getTargetPackages();
            HashSet<String> hashSet = new HashSet<String>();
            for (Strategy strategy : this.namedStrategy) {
                hashSet.addAll(strategy.getTargetPackages());
            }
            set.retainAll(hashSet);
            this.strategy.removeTargetsByPackage(set);
        }

        @Override
        public void parseJson(@Nullable JSONObject jSONObject) {
            if (jSONObject == null) {
                return;
            }
            try {
                JSONArray jSONArray;
                if (jSONObject.has("namedStrategy")) {
                    jSONArray = jSONObject.getJSONArray("namedStrategy");
                    this.namedStrategy = Strategy.createFromJSONArray(jSONArray);
                }
                if (jSONObject.has("uploadTarget")) {
                    jSONArray = jSONObject.optJSONArray("uploadTarget");
                    this.uploadTarget = c.a(jSONArray);
                }
                if (jSONObject.has("uploadConfig")) {
                    jSONArray = jSONObject.optJSONObject("uploadConfig");
                    this.uploadConfig.parseJson((JSONObject)jSONArray);
                }
                jSONArray = jSONObject.optJSONObject("strategy");
                JSONArray jSONArray2 = jSONObject.optJSONArray("target");
                this.strategy.parseJson((JSONObject)jSONArray);
                this.target = c.a(jSONArray2);
                this.strategy.setTarget(this.target);
                this.duplicateTarget();
            }
            catch (Exception exception) {
                a.a(exception);
            }
        }

        @Override
        public JSONObject toJson() {
            JSONObject jSONObject = new JSONObject();
            q.a(jSONObject, "strategy", this.strategy);
            q.a(jSONObject, "target", this.target);
            q.a(jSONObject, "namedStrategy", this.namedStrategy);
            q.a(jSONObject, "uploadTarget", this.uploadTarget);
            q.a(jSONObject, "uploadConfig", this.uploadConfig);
            return jSONObject;
        }
    }
}

