/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.advance.supplier.ks.R;
import com.kwad.sdk.KsAdSDKImpl;
import com.kwad.sdk.core.imageloader.cache.disc.naming.Md5FileNameGenerator;
import com.kwad.sdk.core.imageloader.core.DisplayImageOptions;
import com.kwad.sdk.core.imageloader.core.ImageLoader;
import com.kwad.sdk.core.imageloader.core.ImageLoaderConfiguration;
import com.kwad.sdk.core.imageloader.core.assist.FailReason;
import com.kwad.sdk.core.imageloader.core.assist.QueueProcessingType;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.display.CircleBitmapDisplayer;
import com.kwad.sdk.core.imageloader.core.display.RoundedBitmapDisplayer;
import com.kwad.sdk.core.imageloader.core.listener.ImageLoadingListener;
import com.kwad.sdk.core.report.d;
import com.kwad.sdk.core.response.model.AdTemplate;
import com.kwad.sdk.utils.at;
import java.io.InputStream;

public class KSImageLoader {
    public static DisplayImageOptions IMGOPTION_NORMAL = new DisplayImageOptions.Builder().bitmapConfig(Bitmap.Config.ARGB_8888).cacheOnDisk(true).cacheInMemory(true).build();
    public static DisplayImageOptions IMGOPTION_ENTRY;
    public static DisplayImageOptions IMGOPTION_TUBE;
    public static DisplayImageOptions IMGOPTION_TREND;

    public static void init(Context context) {
        if (context == null) {
            return;
        }
        IMGOPTION_ENTRY = new DisplayImageOptions.Builder().bitmapConfig(Bitmap.Config.ARGB_8888).cacheOnDisk(true).cacheInMemory(true).showImageOnLoading(R.drawable.ksad_loading_entry).showImageForEmptyUri(R.drawable.ksad_loading_entry).showImageOnFail(R.drawable.ksad_loading_entry).build();
        IMGOPTION_TUBE = new DisplayImageOptions.Builder().bitmapConfig(Bitmap.Config.RGB_565).cacheOnDisk(true).cacheInMemory(true).showImageOnLoading(R.drawable.ksad_tube_episode_cover_bg).showImageForEmptyUri(R.drawable.ksad_tube_episode_cover_bg).showImageOnFail(R.drawable.ksad_tube_episode_cover_bg).build();
        IMGOPTION_TREND = new DisplayImageOptions.Builder().bitmapConfig(Bitmap.Config.RGB_565).cacheOnDisk(true).cacheInMemory(true).showImageOnLoading(R.drawable.ksad_trend_panel_item_cover_bg).showImageForEmptyUri(R.drawable.ksad_trend_panel_item_cover_bg).showImageOnFail(R.drawable.ksad_trend_panel_item_cover_bg).build();
        ImageLoaderConfiguration.Builder builder = new ImageLoaderConfiguration.Builder(context.getApplicationContext());
        builder.threadPriority(3);
        builder.denyCacheImageMultipleSizesInMemory();
        builder.diskCacheFileNameGenerator(new Md5FileNameGenerator());
        builder.diskCacheSize(0x1400000);
        builder.tasksProcessingOrder(QueueProcessingType.LIFO);
        ImageLoader.getInstance().init(builder.build());
    }

    private static void checkInit() {
        if (!ImageLoader.getInstance().isInited()) {
            KSImageLoader.init(KsAdSDKImpl.get().getContext());
        }
    }

    public static void preloadImage(String string, AdTemplate adTemplate) {
        KSImageLoader.loadImage(string, adTemplate, IMGOPTION_NORMAL, null);
    }

    public static void loadImage(String string, AdTemplate adTemplate, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        if (TextUtils.isEmpty((CharSequence)string) || KsAdSDKImpl.get().getContext() == null) {
            return;
        }
        KSImageLoader.checkInit();
        ImageLoader.getInstance().loadImage(string, displayImageOptions, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, imageLoadingListener));
    }

    public static void loadImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate) {
        KSImageLoader.loadImage(imageView, string, adTemplate, IMGOPTION_NORMAL);
    }

    public static void loadImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate, DisplayImageOptions displayImageOptions) {
        if (imageView == null) {
            return;
        }
        KSImageLoader.checkInit();
        if (displayImageOptions == null) {
            displayImageOptions = IMGOPTION_NORMAL;
        }
        ImageLoader.getInstance().displayImage(string, imageView, displayImageOptions, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, null));
    }

    public static void loadImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        KSImageLoader.checkInit();
        if (displayImageOptions == null) {
            displayImageOptions = IMGOPTION_NORMAL;
        }
        ImageLoader.getInstance().displayImage(string, imageView, displayImageOptions, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, imageLoadingListener));
    }

    public static void loadImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate, ImageLoadingListener imageLoadingListener) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        KSImageLoader.checkInit();
        ImageLoader.getInstance().displayImage(string, imageView, IMGOPTION_NORMAL, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, imageLoadingListener));
    }

    public static void loadFeeImage(ImageView imageView, @Nullable String string, AdTemplate adTemplate) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        KSImageLoader.checkInit();
        DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().bitmapConfig(Bitmap.Config.RGB_565).cacheInMemory(true).cacheOnDisk(true).displayer(new RoundedBitmapDisplayer(at.a(imageView.getContext(), 1.0f))).build();
        ImageLoader.getInstance().displayImage(string, imageView, displayImageOptions, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, null));
    }

    public static void loadAppIcon(ImageView imageView, @Nullable String string, AdTemplate adTemplate, int n2) {
        if (imageView == null || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        KSImageLoader.checkInit();
        DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().showImageOnLoading(imageView.getContext().getResources().getDrawable(R.drawable.ksad_default_app_icon)).showImageForEmptyUri(imageView.getContext().getResources().getDrawable(R.drawable.ksad_default_app_icon)).showImageOnFail(imageView.getContext().getResources().getDrawable(R.drawable.ksad_default_app_icon)).considerExifParams(true).bitmapConfig(Bitmap.Config.RGB_565).displayer(new RoundedBitmapDisplayer(at.a(imageView.getContext(), (float)n2))).build();
        ImageLoader.getInstance().displayImage(string, imageView, displayImageOptions, (ImageLoadingListener)new InnerImageLoadingListener(adTemplate, null));
    }

    public static void loadCircleIcon(ImageView imageView, String string, Drawable drawable2, @ColorInt int n2) {
        if (imageView == null) {
            return;
        }
        KSImageLoader.checkInit();
        DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().showImageOnLoading(drawable2).showImageForEmptyUri(drawable2).showImageOnFail(drawable2).cacheInMemory(true).cacheOnDisc(true).bitmapConfig(Bitmap.Config.RGB_565).displayer(new CircleBitmapDisplayer(n2, at.a(imageView.getContext(), 1.0f))).build();
        ImageLoader.getInstance().displayImage(string, imageView, displayImageOptions);
    }

    public static void loadAuthorCircleIcon(ImageView imageView, String string) {
        KSImageLoader.loadCircleIcon(imageView, string, imageView.getContext().getResources().getDrawable(R.drawable.ksad_photo_default_author_icon));
    }

    public static void loadCircleIconWithoutStroke(ImageView imageView, String string, Drawable drawable2) {
        if (imageView == null) {
            return;
        }
        KSImageLoader.checkInit();
        DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().showImageOnLoading(drawable2).showImageForEmptyUri(drawable2).showImageOnFail(drawable2).cacheInMemory(true).cacheOnDisc(true).bitmapConfig(Bitmap.Config.RGB_565).displayer(new CircleBitmapDisplayer()).build();
        ImageLoader.getInstance().displayImage(string, imageView, displayImageOptions);
    }

    public static void loadCircleIcon(ImageView imageView, String string, Drawable drawable2) {
        if (imageView == null) {
            return;
        }
        KSImageLoader.checkInit();
        DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().showImageOnLoading(drawable2).showImageForEmptyUri(drawable2).showImageOnFail(drawable2).cacheInMemory(true).cacheOnDisc(true).bitmapConfig(Bitmap.Config.RGB_565).displayer(new CircleBitmapDisplayer(Color.argb((int)255, (int)255, (int)255, (int)255), at.a(imageView.getContext(), 1.0f))).build();
        ImageLoader.getInstance().displayImage(string, imageView, displayImageOptions);
    }

    @RequiresApi(api=17)
    public static Bitmap blur(Context context, Bitmap bitmap, @IntRange(from=1L, to=25L) int n2) {
        RenderScript renderScript = RenderScript.create((Context)context);
        Allocation allocation = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap);
        ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)allocation.getElement());
        scriptIntrinsicBlur.setInput(allocation);
        scriptIntrinsicBlur.setRadius((float)n2);
        scriptIntrinsicBlur.forEach(allocation);
        allocation.copyTo(bitmap);
        renderScript.destroy();
        return bitmap;
    }

    public static void resume() {
        KSImageLoader.checkInit();
        ImageLoader.getInstance().resume();
    }

    public static void pause() {
        KSImageLoader.checkInit();
        ImageLoader.getInstance().pause();
    }

    public static void clearMemory() {
        ImageLoader.getInstance().clearMemoryCache();
    }

    private static class InnerImageLoadingListener
    implements ImageLoadingListener {
        @Nullable
        AdTemplate adTemplate;
        ImageLoadingListener loadingListener;

        public InnerImageLoadingListener(@Nullable AdTemplate adTemplate, ImageLoadingListener imageLoadingListener) {
            this.adTemplate = adTemplate;
            this.loadingListener = imageLoadingListener;
        }

        @Override
        public void onLoadingStarted(String string, View view) {
            if (this.loadingListener != null) {
                this.loadingListener.onLoadingStarted(string, view);
            }
        }

        @Override
        public void onLoadingFailed(String string, View view, FailReason failReason) {
            if (this.loadingListener != null) {
                this.loadingListener.onLoadingFailed(string, view, failReason);
            }
            if (this.adTemplate != null) {
                StringBuilder stringBuilder = new StringBuilder("ImageLoader:");
                if (failReason != null) {
                    Throwable throwable = failReason.getCause();
                    String string2 = "";
                    if (throwable != null && throwable.getStackTrace().length > 0) {
                        string2 = throwable.getMessage() + " @ " + throwable.getStackTrace()[0].getFileName() + throwable.getStackTrace()[0].getClassName() + throwable.getStackTrace()[0].getLineNumber();
                    }
                    switch (failReason.getType()) {
                        case UNKNOWN: {
                            stringBuilder.append("UNKNOWN");
                            break;
                        }
                        case IO_ERROR: {
                            stringBuilder.append("IO_ERROR").append(string2);
                            break;
                        }
                        case OUT_OF_MEMORY: {
                            stringBuilder.append("OUT_OF_MEMORY");
                            break;
                        }
                        case NETWORK_DENIED: {
                            stringBuilder.append("NETWORK_DENIED");
                            break;
                        }
                        case DECODING_ERROR: {
                            stringBuilder.append("DECODING_ERROR");
                        }
                    }
                }
                d.a(this.adTemplate, string, stringBuilder.toString());
            }
        }

        @Override
        public boolean onDecode(String string, InputStream inputStream, DecodedResult decodedResult) {
            if (this.loadingListener != null) {
                return this.loadingListener.onDecode(string, inputStream, decodedResult);
            }
            return false;
        }

        @Override
        public void onLoadingComplete(String string, View view, DecodedResult decodedResult) {
            if (this.loadingListener != null) {
                this.loadingListener.onLoadingComplete(string, view, decodedResult);
            }
        }

        @Override
        public void onLoadingCancelled(String string, View view) {
            if (this.loadingListener != null) {
                this.loadingListener.onLoadingCancelled(string, view);
            }
        }
    }
}

