/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.disc.impl;

import android.graphics.Bitmap;
import com.kwad.sdk.core.imageloader.cache.disc.impl.BaseDiskCache;
import com.kwad.sdk.core.imageloader.cache.disc.naming.FileNameGenerator;
import com.kwad.sdk.core.imageloader.core.DefaultConfigurationFactory;
import com.kwad.sdk.core.imageloader.utils.IoUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeDiskCache
extends BaseDiskCache {
    private final long maxFileAge;
    private final Map<File, Long> loadingDates = Collections.synchronizedMap(new HashMap());

    public LimitedAgeDiskCache(File file, long l2) {
        this(file, null, DefaultConfigurationFactory.createFileNameGenerator(), l2);
    }

    public LimitedAgeDiskCache(File file, File file2, long l2) {
        this(file, file2, DefaultConfigurationFactory.createFileNameGenerator(), l2);
    }

    public LimitedAgeDiskCache(File file, File file2, FileNameGenerator fileNameGenerator, long l2) {
        super(file, file2, fileNameGenerator);
        this.maxFileAge = l2 * 1000L;
    }

    @Override
    public File get(String string2) {
        File file = super.get(string2);
        if (file != null && file.exists()) {
            boolean bl2;
            Long l2 = this.loadingDates.get(file);
            if (l2 == null) {
                bl2 = false;
                l2 = file.lastModified();
            } else {
                bl2 = true;
            }
            if (System.currentTimeMillis() - l2 > this.maxFileAge) {
                file.delete();
                this.loadingDates.remove(file);
            } else if (!bl2) {
                this.loadingDates.put(file, l2);
            }
        }
        return file;
    }

    @Override
    public boolean save(String string2, InputStream inputStream, IoUtils.CopyListener copyListener) {
        boolean bl2 = super.save(string2, inputStream, copyListener);
        this.rememberUsage(string2);
        return bl2;
    }

    @Override
    public boolean save(String string2, Bitmap bitmap) {
        boolean bl2 = super.save(string2, bitmap);
        this.rememberUsage(string2);
        return bl2;
    }

    @Override
    public boolean remove(String string2) {
        this.loadingDates.remove(this.getFile(string2));
        return super.remove(string2);
    }

    @Override
    public void clear() {
        super.clear();
        this.loadingDates.clear();
    }

    private void rememberUsage(String string2) {
        File file = this.getFile(string2);
        long l2 = System.currentTimeMillis();
        file.setLastModified(l2);
        this.loadingDates.put(file, l2);
    }
}

