/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.disc.impl.ext;

import com.kwad.sdk.core.imageloader.cache.disc.impl.ext.StrictLineReader;
import com.kwad.sdk.core.imageloader.cache.disc.impl.ext.Util;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DiskLruCache
implements Closeable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    static final Pattern LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,64}");
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    private int maxFileCount;
    private final int valueCount;
    private long size = 0L;
    private int fileCount = 0;
    private Writer journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private int redundantOpCount;
    private long nextSequenceNumber = 0L;
    final ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> cleanupCallable = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (DiskLruCache.this.journalWriter == null) {
                    return null;
                }
                DiskLruCache.this.trimToSize();
                DiskLruCache.this.trimToFileCount();
                if (DiskLruCache.this.journalRebuildRequired()) {
                    DiskLruCache.this.rebuildJournal();
                    DiskLruCache.this.redundantOpCount = 0;
                }
            }
            return null;
        }
    };
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int n2) {
        }
    };

    private DiskLruCache(File file, int n2, int n3, long l2, int n4) {
        this.directory = file;
        this.appVersion = n2;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n3;
        this.maxSize = l2;
        this.maxFileCount = n4;
    }

    public static DiskLruCache open(File file, int n2, int n3, long l2, int n4) {
        Object object;
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("maxFileCount <= 0");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        File file2 = new File(file, JOURNAL_FILE_BACKUP);
        if (file2.exists()) {
            object = new File(file, JOURNAL_FILE);
            if (((File)object).exists()) {
                file2.delete();
            } else {
                DiskLruCache.renameTo(file2, (File)object, false);
            }
        }
        object = new DiskLruCache(file, n2, n3, l2, n4);
        if (((DiskLruCache)object).journalFile.exists()) {
            try {
                super.readJournal();
                super.processJournal();
                ((DiskLruCache)object).journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(((DiskLruCache)object).journalFile, true), Util.US_ASCII));
                return object;
            }
            catch (IOException iOException) {
                System.out.println("DiskLruCache " + file + " is corrupt: " + iOException.getMessage() + ", removing");
                ((DiskLruCache)object).delete();
            }
        }
        file.mkdirs();
        object = new DiskLruCache(file, n2, n3, l2, n4);
        super.rebuildJournal();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJournal() {
        StrictLineReader strictLineReader = new StrictLineReader(new FileInputStream(this.journalFile), Util.US_ASCII);
        try {
            String string2 = strictLineReader.readLine();
            String string3 = strictLineReader.readLine();
            String string4 = strictLineReader.readLine();
            String string5 = strictLineReader.readLine();
            String string6 = strictLineReader.readLine();
            if (!(MAGIC.equals(string2) && VERSION_1.equals(string3) && Integer.toString(this.appVersion).equals(string4) && Integer.toString(this.valueCount).equals(string5) && "".equals(string6))) {
                throw new IOException("unexpected journal header: [" + string2 + ", " + string3 + ", " + string5 + ", " + string6 + "]");
            }
            int n2 = 0;
            try {
                while (true) {
                    this.readJournalLine(strictLineReader.readLine());
                    ++n2;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = n2 - this.lruEntries.size();
                Util.closeQuietly(strictLineReader);
            }
        }
        catch (Throwable throwable) {
            Util.closeQuietly(strictLineReader);
            throw throwable;
        }
    }

    private void readJournalLine(String string2) {
        Entry entry;
        String string3;
        int n2 = string2.indexOf(32);
        if (n2 == -1) {
            throw new IOException("unexpected journal line: " + string2);
        }
        int n3 = n2 + 1;
        int n4 = string2.indexOf(32, n3);
        if (n4 == -1) {
            string3 = string2.substring(n3);
            if (n2 == REMOVE.length() && string2.startsWith(REMOVE)) {
                this.lruEntries.remove(string3);
                return;
            }
        } else {
            string3 = string2.substring(n3, n4);
        }
        if ((entry = this.lruEntries.get(string3)) == null) {
            entry = new Entry(string3);
            this.lruEntries.put(string3, entry);
        }
        if (n4 != -1 && n2 == CLEAN.length() && string2.startsWith(CLEAN)) {
            String[] stringArray = string2.substring(n4 + 1).split(" ");
            entry.readable = true;
            entry.currentEditor = null;
            entry.setLengths(stringArray);
        } else if (n4 == -1 && n2 == DIRTY.length() && string2.startsWith(DIRTY)) {
            entry.currentEditor = new Editor(entry);
        } else if (n4 != -1 || n2 != READ.length() || !string2.startsWith(READ)) {
            throw new IOException("unexpected journal line: " + string2);
        }
    }

    private void processJournal() {
        DiskLruCache.deleteIfExists(this.journalFileTmp);
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n2 = 0; n2 < this.valueCount; ++n2) {
                    this.size += entry.lengths[n2];
                    ++this.fileCount;
                }
                continue;
            }
            entry.currentEditor = null;
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                DiskLruCache.deleteIfExists(entry.getCleanFile(n2));
                DiskLruCache.deleteIfExists(entry.getDirtyFile(n2));
            }
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rebuildJournal() {
        if (this.journalWriter != null) {
            this.journalWriter.close();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFileTmp), Util.US_ASCII));){
            bufferedWriter.write(MAGIC);
            bufferedWriter.write("\n");
            bufferedWriter.write(VERSION_1);
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.appVersion));
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.valueCount));
            bufferedWriter.write("\n");
            bufferedWriter.write("\n");
            for (Entry entry : this.lruEntries.values()) {
                if (entry.currentEditor != null) {
                    bufferedWriter.write("DIRTY " + entry.key + '\n');
                    continue;
                }
                bufferedWriter.write("CLEAN " + entry.key + entry.getLengths() + '\n');
            }
        }
        if (this.journalFile.exists()) {
            DiskLruCache.renameTo(this.journalFile, this.journalFileBackup, true);
        }
        DiskLruCache.renameTo(this.journalFileTmp, this.journalFile, false);
        this.journalFileBackup.delete();
        this.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), Util.US_ASCII));
    }

    private static void deleteIfExists(File file) {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    private static void renameTo(File file, File file2, boolean bl2) {
        if (bl2) {
            DiskLruCache.deleteIfExists(file2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException();
        }
    }

    public synchronized Snapshot get(String string2) {
        this.checkNotClosed();
        this.validateKey(string2);
        Entry entry = this.lruEntries.get(string2);
        if (entry == null) {
            return null;
        }
        if (!entry.readable) {
            return null;
        }
        File[] fileArray = new File[this.valueCount];
        InputStream[] inputStreamArray = new InputStream[this.valueCount];
        try {
            for (int i2 = 0; i2 < this.valueCount; ++i2) {
                File file;
                fileArray[i2] = file = entry.getCleanFile(i2);
                inputStreamArray[i2] = new FileInputStream(file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            for (int i3 = 0; i3 < this.valueCount && inputStreamArray[i3] != null; ++i3) {
                Util.closeQuietly(inputStreamArray[i3]);
            }
            return null;
        }
        ++this.redundantOpCount;
        this.journalWriter.append("READ " + string2 + '\n');
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return new Snapshot(string2, entry.sequenceNumber, fileArray, inputStreamArray, entry.lengths);
    }

    public Editor edit(String string2) {
        return this.edit(string2, -1L);
    }

    private synchronized Editor edit(String string2, long l2) {
        this.checkNotClosed();
        this.validateKey(string2);
        Entry entry = this.lruEntries.get(string2);
        if (l2 != -1L && (entry == null || entry.sequenceNumber != l2)) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(string2);
            this.lruEntries.put(string2, entry);
        } else if (entry.currentEditor != null) {
            return null;
        }
        Editor editor = new Editor(entry);
        entry.currentEditor = editor;
        this.journalWriter.write("DIRTY " + string2 + '\n');
        this.journalWriter.flush();
        return editor;
    }

    public File getDirectory() {
        return this.directory;
    }

    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    public synchronized int getMaxFileCount() {
        return this.maxFileCount;
    }

    public synchronized void setMaxSize(long l2) {
        this.maxSize = l2;
        this.executorService.submit(this.cleanupCallable);
    }

    public synchronized long size() {
        return this.size;
    }

    public synchronized long fileCount() {
        return this.fileCount;
    }

    private synchronized void completeEdit(Editor editor, boolean bl2) {
        int n2;
        Entry entry = editor.entry;
        if (entry.currentEditor != editor) {
            throw new IllegalStateException();
        }
        if (bl2 && !entry.readable) {
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                if (!editor.written[n2]) {
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + n2);
                }
                if (entry.getDirtyFile(n2).exists()) continue;
                editor.abort();
                return;
            }
        }
        for (n2 = 0; n2 < this.valueCount; ++n2) {
            File file = entry.getDirtyFile(n2);
            if (bl2) {
                long l2;
                if (!file.exists()) continue;
                File file2 = entry.getCleanFile(n2);
                file.renameTo(file2);
                long l3 = entry.lengths[n2];
                ((Entry)entry).lengths[n2] = l2 = file2.length();
                this.size = this.size - l3 + l2;
                ++this.fileCount;
                continue;
            }
            DiskLruCache.deleteIfExists(file);
        }
        ++this.redundantOpCount;
        entry.currentEditor = null;
        if (entry.readable | bl2) {
            entry.readable = true;
            this.journalWriter.write("CLEAN " + entry.key + entry.getLengths() + '\n');
            if (bl2) {
                entry.sequenceNumber = this.nextSequenceNumber++;
            }
        } else {
            this.lruEntries.remove(entry.key);
            this.journalWriter.write("REMOVE " + entry.key + '\n');
        }
        this.journalWriter.flush();
        if (this.size > this.maxSize || this.fileCount > this.maxFileCount || this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
    }

    private boolean journalRebuildRequired() {
        int n2 = 2000;
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    public synchronized boolean remove(String string2) {
        this.checkNotClosed();
        this.validateKey(string2);
        Entry entry = this.lruEntries.get(string2);
        if (entry == null || entry.currentEditor != null) {
            return false;
        }
        for (int i2 = 0; i2 < this.valueCount; ++i2) {
            File file = entry.getCleanFile(i2);
            if (file.exists() && !file.delete()) {
                throw new IOException("failed to delete " + file);
            }
            this.size -= entry.lengths[i2];
            --this.fileCount;
            ((Entry)entry).lengths[i2] = 0L;
        }
        ++this.redundantOpCount;
        this.journalWriter.append("REMOVE " + string2 + '\n');
        this.lruEntries.remove(string2);
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return true;
    }

    public synchronized boolean isClosed() {
        return this.journalWriter == null;
    }

    private void checkNotClosed() {
        if (this.journalWriter == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public synchronized void flush() {
        this.checkNotClosed();
        this.trimToSize();
        this.trimToFileCount();
        this.journalWriter.flush();
    }

    @Override
    public synchronized void close() {
        if (this.journalWriter == null) {
            return;
        }
        for (Entry entry : new ArrayList<Entry>(this.lruEntries.values())) {
            if (entry.currentEditor == null) continue;
            entry.currentEditor.abort();
        }
        this.trimToSize();
        this.trimToFileCount();
        this.journalWriter.close();
        this.journalWriter = null;
    }

    private void trimToSize() {
        while (this.size > this.maxSize) {
            Map.Entry<String, Entry> entry = this.lruEntries.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    private void trimToFileCount() {
        while (this.fileCount > this.maxFileCount) {
            Map.Entry<String, Entry> entry = this.lruEntries.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public void delete() {
        this.close();
        Util.deleteContents(this.directory);
    }

    private void validateKey(String string2) {
        Matcher matcher = LEGAL_KEY_PATTERN.matcher(string2);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,64}: \"" + string2 + "\"");
        }
    }

    private static String inputStreamToString(InputStream inputStream) {
        return Util.readFully(new InputStreamReader(inputStream, Util.UTF_8));
    }

    private final class Entry {
        private final String key;
        private final long[] lengths;
        private boolean readable;
        private Editor currentEditor;
        private long sequenceNumber;

        private Entry(String string2) {
            this.key = string2;
            this.lengths = new long[DiskLruCache.this.valueCount];
        }

        public String getLengths() {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l2 : this.lengths) {
                stringBuilder.append(' ').append(l2);
            }
            return stringBuilder.toString();
        }

        private void setLengths(String[] stringArray) {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            try {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.lengths[i2] = Long.parseLong(stringArray[i2]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidLengths(stringArray);
            }
        }

        private IOException invalidLengths(String[] stringArray) {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        public File getCleanFile(int n2) {
            return new File(DiskLruCache.this.directory, this.key + "." + n2);
        }

        public File getDirtyFile(int n2) {
            return new File(DiskLruCache.this.directory, this.key + "." + n2 + ".tmp");
        }
    }

    public final class Editor {
        private final Entry entry;
        private final boolean[] written;
        private boolean hasErrors;
        private boolean committed;

        private Editor(Entry entry) {
            this.entry = entry;
            this.written = entry.readable ? null : new boolean[DiskLruCache.this.valueCount];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream newInputStream(int n2) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    return null;
                }
                try {
                    return new FileInputStream(this.entry.getCleanFile(n2));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }

        public String getString(int n2) {
            InputStream inputStream = this.newInputStream(n2);
            return inputStream != null ? DiskLruCache.inputStreamToString(inputStream) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream newOutputStream(int n2) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                FileOutputStream fileOutputStream;
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    this.written[n2] = true;
                }
                File file = this.entry.getDirtyFile(n2);
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    DiskLruCache.this.directory.mkdirs();
                    try {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    catch (FileNotFoundException fileNotFoundException2) {
                        return NULL_OUTPUT_STREAM;
                    }
                }
                return new FaultHidingOutputStream(fileOutputStream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int n2, String string2) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(this.newOutputStream(n2), Util.UTF_8);
                outputStreamWriter.write(string2);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            Util.closeQuietly(outputStreamWriter);
        }

        public void commit() {
            if (this.hasErrors) {
                DiskLruCache.this.completeEdit(this, false);
                DiskLruCache.this.remove(this.entry.key);
            } else {
                DiskLruCache.this.completeEdit(this, true);
            }
            this.committed = true;
        }

        public void abort() {
            DiskLruCache.this.completeEdit(this, false);
        }

        public void abortUnlessCommitted() {
            if (!this.committed) {
                try {
                    this.abort();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private class FaultHidingOutputStream
        extends FilterOutputStream {
            private FaultHidingOutputStream(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n2) {
                try {
                    this.out.write(n2);
                }
                catch (IOException iOException) {
                    Editor.this.hasErrors = true;
                }
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) {
                try {
                    this.out.write(byArray, n2, n3);
                }
                catch (IOException iOException) {
                    Editor.this.hasErrors = true;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    Editor.this.hasErrors = true;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    Editor.this.hasErrors = true;
                }
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long sequenceNumber;
        private File[] files;
        private final InputStream[] ins;
        private final long[] lengths;

        private Snapshot(String string2, long l2, File[] fileArray, InputStream[] inputStreamArray, long[] lArray) {
            this.key = string2;
            this.sequenceNumber = l2;
            this.files = fileArray;
            this.ins = inputStreamArray;
            this.lengths = lArray;
        }

        public Editor edit() {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public File getFile(int n2) {
            return this.files[n2];
        }

        public InputStream getInputStream(int n2) {
            return this.ins[n2];
        }

        public String getString(int n2) {
            return DiskLruCache.inputStreamToString(this.getInputStream(n2));
        }

        public long getLength(int n2) {
            return this.lengths[n2];
        }

        @Override
        public void close() {
            for (InputStream inputStream : this.ins) {
                Util.closeQuietly(inputStream);
            }
        }
    }
}

