/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.disc.impl.ext;

import android.graphics.Bitmap;
import com.kwad.sdk.core.imageloader.cache.disc.DiskCache;
import com.kwad.sdk.core.imageloader.cache.disc.impl.ext.DiskLruCache;
import com.kwad.sdk.core.imageloader.cache.disc.naming.FileNameGenerator;
import com.kwad.sdk.core.imageloader.utils.IoUtils;
import com.kwad.sdk.core.imageloader.utils.L;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LruDiskCache
implements DiskCache {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.PNG;
    public static final int DEFAULT_COMPRESS_QUALITY = 100;
    private static final String ERROR_ARG_NULL = " argument must be not null";
    private static final String ERROR_ARG_NEGATIVE = " argument must be positive number";
    protected DiskLruCache cache;
    private File reserveCacheDir;
    protected final FileNameGenerator fileNameGenerator;
    protected int bufferSize = 32768;
    protected Bitmap.CompressFormat compressFormat = DEFAULT_COMPRESS_FORMAT;
    protected int compressQuality = 100;

    public LruDiskCache(File file, FileNameGenerator fileNameGenerator, long l2) {
        this(file, null, fileNameGenerator, l2, 0);
    }

    public LruDiskCache(File file, File file2, FileNameGenerator fileNameGenerator, long l2, int n2) {
        if (file == null) {
            throw new IllegalArgumentException("cacheDir argument must be not null");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("cacheMaxSize argument must be positive number");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("cacheMaxFileCount argument must be positive number");
        }
        if (fileNameGenerator == null) {
            throw new IllegalArgumentException("fileNameGenerator argument must be not null");
        }
        if (l2 == 0L) {
            l2 = Long.MAX_VALUE;
        }
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        this.reserveCacheDir = file2;
        this.fileNameGenerator = fileNameGenerator;
        this.initCache(file, file2, l2, n2);
    }

    private void initCache(File file, File file2, long l2, int n2) {
        block3: {
            try {
                this.cache = DiskLruCache.open(file, 1, 1, l2, n2);
            }
            catch (IOException iOException) {
                L.e(iOException);
                if (file2 != null) {
                    this.initCache(file2, null, l2, n2);
                }
                if (this.cache != null) break block3;
                throw iOException;
            }
        }
    }

    @Override
    public File getDirectory() {
        return this.cache.getDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File get(String string) {
        try (DiskLruCache.Snapshot snapshot = null;){
            snapshot = this.cache.get(this.getKey(string));
            File file = snapshot == null ? null : snapshot.getFile(0);
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(String string, InputStream inputStream, IoUtils.CopyListener copyListener) {
        DiskLruCache.Editor editor = this.cache.edit(this.getKey(string));
        if (editor == null) {
            return false;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(editor.newOutputStream(0), this.bufferSize);
        boolean bl2 = false;
        try {
            bl2 = IoUtils.copyStream(inputStream, bufferedOutputStream, copyListener, this.bufferSize);
        }
        finally {
            IoUtils.closeSilently(bufferedOutputStream);
            if (bl2) {
                editor.commit();
            } else {
                editor.abort();
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save(String string, Bitmap bitmap) {
        DiskLruCache.Editor editor = this.cache.edit(this.getKey(string));
        if (editor == null) {
            return false;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(editor.newOutputStream(0), this.bufferSize);
        boolean bl2 = false;
        try {
            bl2 = bitmap.compress(this.compressFormat, this.compressQuality, (OutputStream)bufferedOutputStream);
        }
        finally {
            IoUtils.closeSilently(bufferedOutputStream);
        }
        if (bl2) {
            editor.commit();
        } else {
            editor.abort();
        }
        return bl2;
    }

    @Override
    public boolean remove(String string) {
        try {
            return this.cache.remove(this.getKey(string));
        }
        catch (IOException iOException) {
            L.e(iOException);
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.cache.close();
        }
        catch (IOException iOException) {
            L.e(iOException);
        }
        this.cache = null;
    }

    @Override
    public void clear() {
        try {
            this.cache.delete();
        }
        catch (IOException iOException) {
            L.e(iOException);
        }
        try {
            this.initCache(this.cache.getDirectory(), this.reserveCacheDir, this.cache.getMaxSize(), this.cache.getMaxFileCount());
        }
        catch (IOException iOException) {
            L.e(iOException);
        }
    }

    private String getKey(String string) {
        return this.fileNameGenerator.generate(string);
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    public void setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setCompressQuality(int n2) {
        this.compressQuality = n2;
    }
}

