/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory;

import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class BaseMemoryCache
implements MemoryCache {
    private final Map<String, Reference<DecodedResult>> softMap = Collections.synchronizedMap(new HashMap());

    @Override
    public DecodedResult get(String string) {
        DecodedResult decodedResult = null;
        Reference<DecodedResult> reference = this.softMap.get(string);
        if (reference != null) {
            decodedResult = reference.get();
        }
        return decodedResult;
    }

    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        this.softMap.put(string, this.createReference(decodedResult));
        return true;
    }

    @Override
    public DecodedResult remove(String string) {
        Reference<DecodedResult> reference = this.softMap.remove(string);
        return reference == null ? null : reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> keys() {
        Map<String, Reference<DecodedResult>> map = this.softMap;
        synchronized (map) {
            return new HashSet<String>(this.softMap.keySet());
        }
    }

    @Override
    public void clear() {
        this.softMap.clear();
    }

    protected abstract Reference<DecodedResult> createReference(DecodedResult var1);
}

