/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory;

import com.kwad.sdk.core.imageloader.cache.memory.BaseMemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.utils.L;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LimitedMemoryCache
extends BaseMemoryCache {
    private static final int MAX_NORMAL_CACHE_SIZE_IN_MB = 16;
    private static final int MAX_NORMAL_CACHE_SIZE = 0x1000000;
    private final int sizeLimit;
    private final AtomicInteger cacheSize;
    private final List<DecodedResult> hardCache = Collections.synchronizedList(new LinkedList());

    public LimitedMemoryCache(int n2) {
        this.sizeLimit = n2;
        this.cacheSize = new AtomicInteger();
        if (n2 > 0x1000000) {
            L.w("You set too large memory cache size (more than %1$d Mb)", 16);
        }
    }

    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        boolean bl2 = false;
        int n2 = this.getSize(decodedResult);
        int n3 = this.getSizeLimit();
        int n4 = this.cacheSize.get();
        if (n2 < n3) {
            while (n4 + n2 > n3) {
                DecodedResult decodedResult2 = this.removeNext();
                if (!this.hardCache.remove(decodedResult2)) continue;
                n4 = this.cacheSize.addAndGet(-this.getSize(decodedResult2));
            }
            this.hardCache.add(decodedResult);
            this.cacheSize.addAndGet(n2);
            bl2 = true;
        }
        super.put(string, decodedResult);
        return bl2;
    }

    @Override
    public DecodedResult remove(String string) {
        DecodedResult decodedResult = super.get(string);
        if (decodedResult != null && this.hardCache.remove(decodedResult)) {
            this.cacheSize.addAndGet(-this.getSize(decodedResult));
        }
        return super.remove(string);
    }

    @Override
    public void clear() {
        this.hardCache.clear();
        this.cacheSize.set(0);
        super.clear();
    }

    protected int getSizeLimit() {
        return this.sizeLimit;
    }

    protected abstract int getSize(DecodedResult var1);

    protected abstract DecodedResult removeNext();
}

