/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.LimitedMemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRULimitedMemoryCache
extends LimitedMemoryCache {
    private static final int INITIAL_CAPACITY = 10;
    private static final float LOAD_FACTOR = 1.1f;
    private final Map<String, DecodedResult> lruCache = Collections.synchronizedMap(new LinkedHashMap(10, 1.1f, true));

    public LRULimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public boolean put(String string2, DecodedResult decodedResult) {
        if (super.put(string2, decodedResult)) {
            this.lruCache.put(string2, decodedResult);
            return true;
        }
        return false;
    }

    @Override
    public DecodedResult get(String string2) {
        this.lruCache.get(string2);
        return super.get(string2);
    }

    @Override
    public DecodedResult remove(String string2) {
        this.lruCache.remove(string2);
        return super.remove(string2);
    }

    @Override
    public void clear() {
        this.lruCache.clear();
        super.clear();
    }

    @Override
    protected int getSize(DecodedResult decodedResult) {
        return decodedResult.getByteSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DecodedResult removeNext() {
        DecodedResult decodedResult = null;
        Map<String, DecodedResult> map = this.lruCache;
        synchronized (map) {
            Iterator<Map.Entry<String, DecodedResult>> iterator = this.lruCache.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, DecodedResult> entry = iterator.next();
                decodedResult = entry.getValue();
                iterator.remove();
            }
        }
        return decodedResult;
    }

    @Override
    protected Reference<DecodedResult> createReference(DecodedResult decodedResult) {
        return new WeakReference<DecodedResult>(decodedResult);
    }
}

