/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.LimitedMemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LargestLimitedMemoryCache
extends LimitedMemoryCache {
    private final Map<DecodedResult, Integer> valueSizes = Collections.synchronizedMap(new HashMap());

    public LargestLimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        if (super.put(string, decodedResult)) {
            this.valueSizes.put(decodedResult, this.getSize(decodedResult));
            return true;
        }
        return false;
    }

    @Override
    public DecodedResult remove(String string) {
        DecodedResult decodedResult = super.get(string);
        if (decodedResult != null) {
            this.valueSizes.remove(decodedResult);
        }
        return super.remove(string);
    }

    @Override
    public void clear() {
        this.valueSizes.clear();
        super.clear();
    }

    @Override
    protected int getSize(DecodedResult decodedResult) {
        return decodedResult.getByteSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DecodedResult removeNext() {
        Integer n2 = null;
        DecodedResult decodedResult = null;
        Set<Map.Entry<DecodedResult, Integer>> set = this.valueSizes.entrySet();
        Map<DecodedResult, Integer> map = this.valueSizes;
        synchronized (map) {
            for (Map.Entry<DecodedResult, Integer> entry : set) {
                if (decodedResult == null) {
                    decodedResult = entry.getKey();
                    n2 = entry.getValue();
                    continue;
                }
                Integer n3 = entry.getValue();
                if (n3 <= n2) continue;
                n2 = n3;
                decodedResult = entry.getKey();
            }
        }
        this.valueSizes.remove(decodedResult);
        return decodedResult;
    }

    @Override
    protected Reference<DecodedResult> createReference(DecodedResult decodedResult) {
        return new WeakReference<DecodedResult>(decodedResult);
    }
}

