/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeMemoryCache
implements MemoryCache {
    private final MemoryCache cache;
    private final long maxAge;
    private final Map<String, Long> loadingDates = Collections.synchronizedMap(new HashMap());

    public LimitedAgeMemoryCache(MemoryCache memoryCache, long l2) {
        this.cache = memoryCache;
        this.maxAge = l2 * 1000L;
    }

    @Override
    public boolean put(String string, DecodedResult decodedResult) {
        boolean bl2 = this.cache.put(string, decodedResult);
        if (bl2) {
            this.loadingDates.put(string, System.currentTimeMillis());
        }
        return bl2;
    }

    @Override
    public DecodedResult get(String string) {
        Long l2 = this.loadingDates.get(string);
        if (l2 != null && System.currentTimeMillis() - l2 > this.maxAge) {
            this.cache.remove(string);
            this.loadingDates.remove(string);
        }
        return this.cache.get(string);
    }

    @Override
    public DecodedResult remove(String string) {
        this.loadingDates.remove(string);
        return this.cache.remove(string);
    }

    @Override
    public Collection<String> keys() {
        return this.cache.keys();
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.loadingDates.clear();
    }
}

