/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.cache.memory.impl;

import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruMemoryCache
implements MemoryCache {
    private final LinkedHashMap<String, DecodedResult> map;
    private final int maxSize;
    private int size;

    public LruMemoryCache(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = n2;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DecodedResult get(String string2) {
        if (string2 == null) {
            throw new NullPointerException("key == null");
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            return this.map.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(String string2, DecodedResult decodedResult) {
        if (string2 == null || decodedResult == null) {
            throw new NullPointerException("key == null || value == null");
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            this.size += this.sizeOf(string2, decodedResult);
            DecodedResult decodedResult2 = this.map.put(string2, decodedResult);
            if (decodedResult2 != null) {
                this.size -= this.sizeOf(string2, decodedResult2);
            }
        }
        this.trimToSize(this.maxSize);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int n2) {
        while (true) {
            LruMemoryCache lruMemoryCache = this;
            synchronized (lruMemoryCache) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= n2 || this.map.isEmpty()) {
                    break;
                }
                Map.Entry<String, DecodedResult> entry = this.map.entrySet().iterator().next();
                if (entry == null) {
                    break;
                }
                String string2 = entry.getKey();
                DecodedResult decodedResult = entry.getValue();
                this.map.remove(string2);
                this.size -= this.sizeOf(string2, decodedResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DecodedResult remove(String string2) {
        if (string2 == null) {
            throw new NullPointerException("key == null");
        }
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            DecodedResult decodedResult = (DecodedResult)this.map.remove(string2);
            if (decodedResult != null) {
                this.size -= this.sizeOf(string2, decodedResult);
            }
            return decodedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> keys() {
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            return new HashSet<String>(this.map.keySet());
        }
    }

    @Override
    public void clear() {
        this.trimToSize(-1);
    }

    private int sizeOf(String string2, DecodedResult decodedResult) {
        return decodedResult.getByteSize();
    }

    public final synchronized String toString() {
        return String.format("LruCache[maxSize=%d]", this.maxSize);
    }
}

