/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import com.kwad.sdk.core.imageloader.cache.disc.DiskCache;
import com.kwad.sdk.core.imageloader.cache.disc.impl.UnlimitedDiskCache;
import com.kwad.sdk.core.imageloader.cache.disc.impl.ext.LruDiskCache;
import com.kwad.sdk.core.imageloader.cache.disc.naming.FileNameGenerator;
import com.kwad.sdk.core.imageloader.cache.disc.naming.HashCodeFileNameGenerator;
import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.cache.memory.impl.LruMemoryCache;
import com.kwad.sdk.core.imageloader.core.assist.QueueProcessingType;
import com.kwad.sdk.core.imageloader.core.assist.deque.LIFOLinkedBlockingDeque;
import com.kwad.sdk.core.imageloader.core.decode.BaseImageDecoder;
import com.kwad.sdk.core.imageloader.core.decode.ImageDecoder;
import com.kwad.sdk.core.imageloader.core.display.BitmapDisplayer;
import com.kwad.sdk.core.imageloader.core.display.SimpleBitmapDisplayer;
import com.kwad.sdk.core.imageloader.core.download.BaseImageDownloader;
import com.kwad.sdk.core.imageloader.core.download.ImageDownloader;
import com.kwad.sdk.core.imageloader.utils.L;
import com.kwad.sdk.core.imageloader.utils.StorageUtils;
import com.kwad.sdk.utils.aj;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultConfigurationFactory {
    public static Executor createExecutor(int n2, int n3, QueueProcessingType queueProcessingType) {
        boolean bl2 = queueProcessingType == QueueProcessingType.LIFO;
        BlockingQueue blockingQueue = (BlockingQueue)((Object)(bl2 ? new LIFOLinkedBlockingDeque() : new LinkedBlockingQueue()));
        return new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)blockingQueue, DefaultConfigurationFactory.createThreadFactory(n3, "uil-pool-"));
    }

    public static Executor createTaskDistributor() {
        return Executors.newCachedThreadPool(DefaultConfigurationFactory.createThreadFactory(5, "uil-pool-d-"));
    }

    public static FileNameGenerator createFileNameGenerator() {
        return new HashCodeFileNameGenerator();
    }

    public static DiskCache createDiskCache(Context context, FileNameGenerator fileNameGenerator, long l2, int n2) {
        File file;
        File file2 = DefaultConfigurationFactory.createReserveDiskCacheDir(context);
        if (l2 > 0L || n2 > 0) {
            file = StorageUtils.getIndividualCacheDirectory(context);
            try {
                return new LruDiskCache(file, file2, fileNameGenerator, l2, n2);
            }
            catch (IOException iOException) {
                L.e(iOException);
            }
        }
        file = aj.b(context);
        return new UnlimitedDiskCache(file, file2, fileNameGenerator);
    }

    private static File createReserveDiskCacheDir(Context context) {
        File file = aj.b(context);
        File file2 = new File(file, "ksad-images");
        if (file2.exists() || file2.mkdir()) {
            file = file2;
        }
        return file;
    }

    public static MemoryCache createMemoryCache(Context context, int n2) {
        if (n2 == 0) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int n3 = activityManager.getMemoryClass();
            if (DefaultConfigurationFactory.hasHoneycomb() && DefaultConfigurationFactory.isLargeHeap(context)) {
                n3 = DefaultConfigurationFactory.getLargeMemoryClass(activityManager);
            }
            n2 = 0x100000 * n3 / 8;
        }
        return new LruMemoryCache(n2);
    }

    private static boolean hasHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    @TargetApi(value=11)
    private static boolean isLargeHeap(Context context) {
        return (context.getApplicationInfo().flags & 0x100000) != 0;
    }

    @TargetApi(value=11)
    private static int getLargeMemoryClass(ActivityManager activityManager) {
        return activityManager.getLargeMemoryClass();
    }

    public static ImageDownloader createImageDownloader(Context context) {
        return new BaseImageDownloader(context);
    }

    public static ImageDecoder createImageDecoder(boolean bl2) {
        return new BaseImageDecoder(bl2);
    }

    public static BitmapDisplayer createBitmapDisplayer() {
        return new SimpleBitmapDisplayer();
    }

    private static ThreadFactory createThreadFactory(int n2, String string) {
        return new DefaultThreadFactory(n2, string);
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final int threadPriority;

        DefaultThreadFactory(int n2, String string) {
            this.threadPriority = n2;
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = string + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            thread.setPriority(this.threadPriority);
            return thread;
        }
    }
}

