/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.kwad.sdk.core.imageloader.cache.disc.DiskCache;
import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.core.DisplayImageOptions;
import com.kwad.sdk.core.imageloader.core.ImageLoaderConfiguration;
import com.kwad.sdk.core.imageloader.core.ImageLoaderEngine;
import com.kwad.sdk.core.imageloader.core.ImageLoadingInfo;
import com.kwad.sdk.core.imageloader.core.LoadAndDisplayImageTask;
import com.kwad.sdk.core.imageloader.core.ProcessAndDisplayImageTask;
import com.kwad.sdk.core.imageloader.core.assist.ImageSize;
import com.kwad.sdk.core.imageloader.core.assist.LoadedFrom;
import com.kwad.sdk.core.imageloader.core.assist.ViewScaleType;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageAware;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageViewAware;
import com.kwad.sdk.core.imageloader.core.imageaware.NonViewAware;
import com.kwad.sdk.core.imageloader.core.listener.ImageLoadingListener;
import com.kwad.sdk.core.imageloader.core.listener.ImageLoadingProgressListener;
import com.kwad.sdk.core.imageloader.core.listener.SimpleImageLoadingListener;
import com.kwad.sdk.core.imageloader.utils.ImageSizeUtils;
import com.kwad.sdk.core.imageloader.utils.L;
import com.kwad.sdk.core.imageloader.utils.MemoryCacheUtils;

public class ImageLoader {
    public static final String TAG = ImageLoader.class.getSimpleName();
    static final String LOG_INIT_CONFIG = "Initialize ImageLoader with configuration";
    static final String LOG_DESTROY = "Destroy ImageLoader";
    static final String LOG_LOAD_IMAGE_FROM_MEMORY_CACHE = "Load image from memory cache [%s]";
    private static final String WARNING_RE_INIT_CONFIG = "Try to initialize ImageLoader which had already been initialized before. To re-init ImageLoader with new configuration call ImageLoader.destroy() at first.";
    private static final String ERROR_WRONG_ARGUMENTS = "Wrong arguments were passed to displayImage() method (ImageView reference must not be null)";
    private static final String ERROR_NOT_INIT = "ImageLoader must be init with configuration before using";
    private static final String ERROR_INIT_CONFIG_WITH_NULL = "ImageLoader configuration can not be initialized with null";
    private volatile ImageLoaderConfiguration configuration;
    private ImageLoaderEngine engine;
    private ImageLoadingListener defaultListener = new SimpleImageLoadingListener();
    private static volatile ImageLoader instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance() {
        if (instance != null) return instance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (instance != null) return instance;
            instance = new ImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ImageLoader() {
    }

    public synchronized void init(ImageLoaderConfiguration imageLoaderConfiguration) {
        if (imageLoaderConfiguration == null) {
            throw new IllegalArgumentException(ERROR_INIT_CONFIG_WITH_NULL);
        }
        if (this.configuration == null) {
            L.d(LOG_INIT_CONFIG, new Object[0]);
            this.engine = new ImageLoaderEngine(imageLoaderConfiguration);
            this.configuration = imageLoaderConfiguration;
        } else {
            L.w(WARNING_RE_INIT_CONFIG, new Object[0]);
        }
    }

    public boolean isInited() {
        return this.configuration != null;
    }

    public void displayImage(String string2, ImageAware imageAware) {
        this.displayImage(string2, imageAware, null, null, null);
    }

    public void displayImage(String string2, ImageAware imageAware, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, imageAware, null, imageLoadingListener, null);
    }

    public void displayImage(String string2, ImageAware imageAware, DisplayImageOptions displayImageOptions) {
        this.displayImage(string2, imageAware, displayImageOptions, null, null);
    }

    public void displayImage(String string2, ImageAware imageAware, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, imageAware, displayImageOptions, imageLoadingListener, null);
    }

    public void displayImage(String string2, ImageAware imageAware, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.displayImage(string2, imageAware, displayImageOptions, null, imageLoadingListener, imageLoadingProgressListener);
    }

    public void displayImage(String string2, ImageAware imageAware, DisplayImageOptions displayImageOptions, ImageSize imageSize, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.checkConfiguration();
        if (imageAware == null) {
            throw new IllegalArgumentException(ERROR_WRONG_ARGUMENTS);
        }
        if (imageLoadingListener == null) {
            imageLoadingListener = this.defaultListener;
        }
        if (displayImageOptions == null) {
            displayImageOptions = this.configuration.defaultDisplayImageOptions;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.engine.cancelDisplayTaskFor(imageAware);
            imageLoadingListener.onLoadingStarted(string2, imageAware.getWrappedView());
            if (displayImageOptions.shouldShowImageForEmptyUri()) {
                imageAware.setImageDrawable(displayImageOptions.getImageForEmptyUri(this.configuration.resources));
            } else {
                imageAware.setImageDrawable(null);
            }
            imageLoadingListener.onLoadingComplete(string2, imageAware.getWrappedView(), null);
            return;
        }
        if (imageSize == null) {
            imageSize = ImageSizeUtils.defineTargetSizeForView(imageAware, this.configuration.getMaxImageSize());
        }
        String string3 = MemoryCacheUtils.generateKey(string2, imageSize);
        this.engine.prepareDisplayTaskFor(imageAware, string3);
        imageLoadingListener.onLoadingStarted(string2, imageAware.getWrappedView());
        DecodedResult decodedResult = this.configuration.memoryCache.get(string3);
        if (decodedResult != null && decodedResult.isDecoded()) {
            L.d(LOG_LOAD_IMAGE_FROM_MEMORY_CACHE, string3);
            if (displayImageOptions.shouldPostProcess()) {
                ImageLoadingInfo imageLoadingInfo = new ImageLoadingInfo(string2, imageAware, imageSize, string3, displayImageOptions, imageLoadingListener, imageLoadingProgressListener, this.engine.getLockForUri(string2));
                ProcessAndDisplayImageTask processAndDisplayImageTask = new ProcessAndDisplayImageTask(this.engine, decodedResult, imageLoadingInfo, ImageLoader.defineHandler(displayImageOptions));
                if (displayImageOptions.isSyncLoading()) {
                    processAndDisplayImageTask.run();
                } else {
                    this.engine.submit(processAndDisplayImageTask);
                }
            } else {
                displayImageOptions.getDisplayer().display(decodedResult, imageAware, LoadedFrom.MEMORY_CACHE);
                imageLoadingListener.onLoadingComplete(string2, imageAware.getWrappedView(), decodedResult);
            }
        } else {
            if (displayImageOptions.shouldShowImageOnLoading()) {
                imageAware.setImageDrawable(displayImageOptions.getImageOnLoading(this.configuration.resources));
            } else if (displayImageOptions.isResetViewBeforeLoading()) {
                imageAware.setImageDrawable(null);
            }
            ImageLoadingInfo imageLoadingInfo = new ImageLoadingInfo(string2, imageAware, imageSize, string3, displayImageOptions, imageLoadingListener, imageLoadingProgressListener, this.engine.getLockForUri(string2));
            LoadAndDisplayImageTask loadAndDisplayImageTask = new LoadAndDisplayImageTask(this.engine, imageLoadingInfo, ImageLoader.defineHandler(displayImageOptions));
            if (displayImageOptions.isSyncLoading()) {
                loadAndDisplayImageTask.run();
            } else {
                this.engine.submit(loadAndDisplayImageTask);
            }
        }
    }

    public void displayImage(String string2, ImageView imageView) {
        this.displayImage(string2, new ImageViewAware(imageView), null, null, null);
    }

    public void displayImage(String string2, ImageView imageView, ImageSize imageSize) {
        this.displayImage(string2, new ImageViewAware(imageView), null, imageSize, null, null);
    }

    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions) {
        this.displayImage(string2, new ImageViewAware(imageView), displayImageOptions, null, null);
    }

    public void displayImage(String string2, ImageView imageView, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, new ImageViewAware(imageView), null, imageLoadingListener, null);
    }

    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, imageView, displayImageOptions, imageLoadingListener, null);
    }

    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.displayImage(string2, new ImageViewAware(imageView), displayImageOptions, imageLoadingListener, imageLoadingProgressListener);
    }

    public void loadImage(String string2, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, null, null, imageLoadingListener, null);
    }

    public void loadImage(String string2, ImageSize imageSize, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, imageSize, null, imageLoadingListener, null);
    }

    public void loadImage(String string2, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, null, displayImageOptions, imageLoadingListener, null);
    }

    public void loadImage(String string2, ImageSize imageSize, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, imageSize, displayImageOptions, imageLoadingListener, null);
    }

    public void loadImage(String string2, ImageSize imageSize, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.checkConfiguration();
        if (imageSize == null) {
            imageSize = this.configuration.getMaxImageSize();
        }
        if (displayImageOptions == null) {
            displayImageOptions = this.configuration.defaultDisplayImageOptions;
        }
        NonViewAware nonViewAware = new NonViewAware(string2, imageSize, ViewScaleType.CROP);
        this.displayImage(string2, nonViewAware, displayImageOptions, imageLoadingListener, imageLoadingProgressListener);
    }

    public Bitmap loadImageSync(String string2) {
        return this.loadImageSync(string2, null, null);
    }

    public Bitmap loadImageSync(String string2, DisplayImageOptions displayImageOptions) {
        return this.loadImageSync(string2, null, displayImageOptions);
    }

    public Bitmap loadImageSync(String string2, ImageSize imageSize) {
        return this.loadImageSync(string2, imageSize, null);
    }

    public Bitmap loadImageSync(String string2, ImageSize imageSize, DisplayImageOptions displayImageOptions) {
        if (displayImageOptions == null) {
            displayImageOptions = this.configuration.defaultDisplayImageOptions;
        }
        displayImageOptions = new DisplayImageOptions.Builder().cloneFrom(displayImageOptions).syncLoading(true).build();
        SyncImageLoadingListener syncImageLoadingListener = new SyncImageLoadingListener();
        this.loadImage(string2, imageSize, displayImageOptions, syncImageLoadingListener);
        return syncImageLoadingListener.getLoadedBitmap();
    }

    private void checkConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException(ERROR_NOT_INIT);
        }
    }

    public void setDefaultLoadingListener(ImageLoadingListener imageLoadingListener) {
        this.defaultListener = imageLoadingListener == null ? new SimpleImageLoadingListener() : imageLoadingListener;
    }

    public MemoryCache getMemoryCache() {
        this.checkConfiguration();
        return this.configuration.memoryCache;
    }

    public void clearMemoryCache() {
        this.checkConfiguration();
        this.configuration.memoryCache.clear();
    }

    @Deprecated
    public DiskCache getDiscCache() {
        return this.getDiskCache();
    }

    public DiskCache getDiskCache() {
        this.checkConfiguration();
        return this.configuration.diskCache;
    }

    @Deprecated
    public void clearDiscCache() {
        this.clearDiskCache();
    }

    public void clearDiskCache() {
        this.checkConfiguration();
        this.configuration.diskCache.clear();
    }

    public String getLoadingUriForView(ImageAware imageAware) {
        return this.engine.getLoadingUriForView(imageAware);
    }

    public String getLoadingUriForView(ImageView imageView) {
        return this.engine.getLoadingUriForView(new ImageViewAware(imageView));
    }

    public void cancelDisplayTask(ImageAware imageAware) {
        this.engine.cancelDisplayTaskFor(imageAware);
    }

    public void cancelDisplayTask(ImageView imageView) {
        this.engine.cancelDisplayTaskFor(new ImageViewAware(imageView));
    }

    public void denyNetworkDownloads(boolean bl2) {
        this.engine.denyNetworkDownloads(bl2);
    }

    public void handleSlowNetwork(boolean bl2) {
        this.engine.handleSlowNetwork(bl2);
    }

    public void pause() {
        this.engine.pause();
    }

    public void resume() {
        this.engine.resume();
    }

    public void stop() {
        this.engine.stop();
    }

    public void destroy() {
        if (this.configuration != null) {
            L.d(LOG_DESTROY, new Object[0]);
        }
        this.stop();
        this.configuration.diskCache.close();
        this.engine = null;
        this.configuration = null;
    }

    private static Handler defineHandler(DisplayImageOptions displayImageOptions) {
        Handler handler = displayImageOptions.getHandler();
        if (displayImageOptions.isSyncLoading()) {
            handler = null;
        } else if (handler == null && Looper.myLooper() == Looper.getMainLooper()) {
            handler = new Handler();
        }
        return handler;
    }

    private static class SyncImageLoadingListener
    extends SimpleImageLoadingListener {
        private Bitmap loadedImage;

        private SyncImageLoadingListener() {
        }

        @Override
        public void onLoadingComplete(String string2, View view, DecodedResult decodedResult) {
            this.loadedImage = decodedResult.mBitmap;
        }

        public Bitmap getLoadedBitmap() {
            return this.loadedImage;
        }
    }
}

