/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import com.kwad.sdk.core.imageloader.core.DisplayBitmapTask;
import com.kwad.sdk.core.imageloader.core.DisplayImageOptions;
import com.kwad.sdk.core.imageloader.core.ImageLoaderConfiguration;
import com.kwad.sdk.core.imageloader.core.ImageLoaderEngine;
import com.kwad.sdk.core.imageloader.core.ImageLoadingInfo;
import com.kwad.sdk.core.imageloader.core.assist.FailReason;
import com.kwad.sdk.core.imageloader.core.assist.ImageScaleType;
import com.kwad.sdk.core.imageloader.core.assist.ImageSize;
import com.kwad.sdk.core.imageloader.core.assist.LoadedFrom;
import com.kwad.sdk.core.imageloader.core.assist.ViewScaleType;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.decode.ImageDecoder;
import com.kwad.sdk.core.imageloader.core.decode.ImageDecodingInfo;
import com.kwad.sdk.core.imageloader.core.download.ImageDownloader;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageAware;
import com.kwad.sdk.core.imageloader.core.listener.ImageLoadingListener;
import com.kwad.sdk.core.imageloader.core.listener.ImageLoadingProgressListener;
import com.kwad.sdk.core.imageloader.utils.IoUtils;
import com.kwad.sdk.core.imageloader.utils.L;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

final class LoadAndDisplayImageTask
implements IoUtils.CopyListener,
Runnable {
    private static final String LOG_WAITING_FOR_RESUME = "ImageLoader is paused. Waiting...  [%s]";
    private static final String LOG_RESUME_AFTER_PAUSE = ".. Resume loading [%s]";
    private static final String LOG_DELAY_BEFORE_LOADING = "Delay %d ms before loading...  [%s]";
    private static final String LOG_START_DISPLAY_IMAGE_TASK = "Start display image task [%s]";
    private static final String LOG_WAITING_FOR_IMAGE_LOADED = "Image already is loading. Waiting... [%s]";
    private static final String LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING = "...Get cached bitmap from memory after waiting. [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_NETWORK = "Load image from network [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_DISK_CACHE = "Load image from disk cache [%s]";
    private static final String LOG_RESIZE_CACHED_IMAGE_FILE = "Resize image in disk cache [%s]";
    private static final String LOG_PREPROCESS_IMAGE = "PreProcess image before caching in memory [%s]";
    private static final String LOG_POSTPROCESS_IMAGE = "PostProcess image before displaying [%s]";
    private static final String LOG_CACHE_IMAGE_IN_MEMORY = "Cache image in memory [%s]";
    private static final String LOG_CACHE_IMAGE_ON_DISK = "Cache image on disk [%s]";
    private static final String LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISK = "Process image before cache on disk [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_REUSED = "ImageAware is reused for another image. Task is cancelled. [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED = "ImageAware was collected by GC. Task is cancelled. [%s]";
    private static final String LOG_TASK_INTERRUPTED = "Task was interrupted [%s]";
    private static final String ERROR_NO_IMAGE_STREAM = "No stream for image [%s]";
    private static final String ERROR_PRE_PROCESSOR_NULL = "Pre-processor returned null [%s]";
    private static final String ERROR_POST_PROCESSOR_NULL = "Post-processor returned null [%s]";
    private static final String ERROR_PROCESSOR_FOR_DISK_CACHE_NULL = "Bitmap processor for disk cache returned null [%s]";
    private final ImageLoaderEngine engine;
    private final ImageLoadingInfo imageLoadingInfo;
    private final Handler handler;
    private final ImageLoaderConfiguration configuration;
    private final ImageDownloader downloader;
    private final ImageDownloader networkDeniedDownloader;
    private final ImageDownloader slowNetworkDownloader;
    private final ImageDecoder decoder;
    final String uri;
    private final String memoryCacheKey;
    final ImageAware imageAware;
    private final ImageSize targetSize;
    final DisplayImageOptions options;
    final ImageLoadingListener listener;
    final ImageLoadingProgressListener progressListener;
    private final boolean syncLoading;
    private LoadedFrom loadedFrom = LoadedFrom.NETWORK;

    public LoadAndDisplayImageTask(ImageLoaderEngine imageLoaderEngine, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.engine = imageLoaderEngine;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
        this.configuration = imageLoaderEngine.configuration;
        this.downloader = this.configuration.downloader;
        this.networkDeniedDownloader = this.configuration.networkDeniedDownloader;
        this.slowNetworkDownloader = this.configuration.slowNetworkDownloader;
        this.decoder = this.configuration.decoder;
        this.uri = imageLoadingInfo.uri;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.imageAware = imageLoadingInfo.imageAware;
        this.targetSize = imageLoadingInfo.targetSize;
        this.options = imageLoadingInfo.options;
        this.listener = imageLoadingInfo.listener;
        this.progressListener = imageLoadingInfo.progressListener;
        this.syncLoading = this.options.isSyncLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.waitIfPaused()) {
            return;
        }
        if (this.delayIfNeed()) {
            return;
        }
        ReentrantLock reentrantLock = this.imageLoadingInfo.loadFromUriLock;
        L.d(LOG_START_DISPLAY_IMAGE_TASK, this.memoryCacheKey);
        if (reentrantLock.isLocked()) {
            L.d(LOG_WAITING_FOR_IMAGE_LOADED, this.memoryCacheKey);
        }
        reentrantLock.lock();
        DecodedResult decodedResult = null;
        try {
            this.checkTaskNotActual();
            decodedResult = this.configuration.memoryCache.get(this.memoryCacheKey);
            if (decodedResult == null || !decodedResult.isDecoded()) {
                decodedResult = this.tryLoadBitmap();
                if (decodedResult == null || !decodedResult.isDecoded()) {
                    return;
                }
                this.checkTaskNotActual();
                this.checkTaskInterrupted();
                if (this.options.shouldPreProcess()) {
                    L.d(LOG_PREPROCESS_IMAGE, this.memoryCacheKey);
                    if (decodedResult.mBitmap != null) {
                        decodedResult.mBitmap = this.options.getPreProcessor().process(decodedResult.mBitmap);
                    }
                    if (decodedResult.mBitmap == null) {
                        L.e(ERROR_PRE_PROCESSOR_NULL, this.memoryCacheKey);
                    }
                }
                if (decodedResult != null && this.options.isCacheInMemory()) {
                    L.d(LOG_CACHE_IMAGE_IN_MEMORY, this.memoryCacheKey);
                    this.configuration.memoryCache.put(this.memoryCacheKey, decodedResult);
                }
            } else {
                this.loadedFrom = LoadedFrom.MEMORY_CACHE;
                L.d(LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING, this.memoryCacheKey);
            }
            if (decodedResult != null && this.options.shouldPostProcess()) {
                L.d(LOG_POSTPROCESS_IMAGE, this.memoryCacheKey);
                decodedResult.mBitmap = this.options.getPostProcessor().process(decodedResult.mBitmap);
                if (decodedResult.mBitmap == null) {
                    L.e(ERROR_POST_PROCESSOR_NULL, this.memoryCacheKey);
                }
            }
            this.checkTaskNotActual();
            this.checkTaskInterrupted();
        }
        catch (TaskCancelledException taskCancelledException) {
            this.fireCancelEvent();
            return;
        }
        finally {
            reentrantLock.unlock();
        }
        DisplayBitmapTask displayBitmapTask = new DisplayBitmapTask(decodedResult, this.imageLoadingInfo, this.engine, this.loadedFrom);
        LoadAndDisplayImageTask.runTask(displayBitmapTask, this.syncLoading, this.handler, this.engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitIfPaused() {
        AtomicBoolean atomicBoolean = this.engine.getPause();
        if (atomicBoolean.get()) {
            Object object = this.engine.getPauseLock();
            synchronized (object) {
                if (atomicBoolean.get()) {
                    L.d(LOG_WAITING_FOR_RESUME, this.memoryCacheKey);
                    try {
                        this.engine.getPauseLock().wait();
                    }
                    catch (InterruptedException interruptedException) {
                        L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                        return true;
                    }
                    L.d(LOG_RESUME_AFTER_PAUSE, this.memoryCacheKey);
                }
            }
        }
        return this.isTaskNotActual();
    }

    private boolean delayIfNeed() {
        if (this.options.shouldDelayBeforeLoading()) {
            L.d(LOG_DELAY_BEFORE_LOADING, this.options.getDelayBeforeLoading(), this.memoryCacheKey);
            try {
                Thread.sleep(this.options.getDelayBeforeLoading());
            }
            catch (InterruptedException interruptedException) {
                L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                return true;
            }
            return this.isTaskNotActual();
        }
        return false;
    }

    private DecodedResult tryLoadBitmap() {
        DecodedResult decodedResult = null;
        try {
            File file = this.configuration.diskCache.get(this.uri);
            if (file != null && file.exists() && file.length() > 0L) {
                L.d(LOG_LOAD_IMAGE_FROM_DISK_CACHE, this.memoryCacheKey);
                this.loadedFrom = LoadedFrom.DISC_CACHE;
                this.checkTaskNotActual();
                decodedResult = this.decodeImage(ImageDownloader.Scheme.FILE.wrap(file.getAbsolutePath()));
            }
            if (decodedResult == null || !decodedResult.isDecoded()) {
                L.d(LOG_LOAD_IMAGE_FROM_NETWORK, this.memoryCacheKey);
                this.loadedFrom = LoadedFrom.NETWORK;
                String string = this.uri;
                if (this.options.isCacheOnDisk() && this.tryCacheImageOnDisk() && (file = this.configuration.diskCache.get(this.uri)) != null) {
                    string = ImageDownloader.Scheme.FILE.wrap(file.getAbsolutePath());
                }
                this.checkTaskNotActual();
                decodedResult = this.decodeImage(string);
            }
            if (decodedResult == null || !decodedResult.isDecoded()) {
                this.fireFailEvent(FailReason.FailType.DECODING_ERROR, null);
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.fireFailEvent(FailReason.FailType.NETWORK_DENIED, null);
        }
        catch (TaskCancelledException taskCancelledException) {
            throw taskCancelledException;
        }
        catch (IOException iOException) {
            L.e(iOException);
            this.fireFailEvent(FailReason.FailType.IO_ERROR, iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            L.e(outOfMemoryError);
            this.fireFailEvent(FailReason.FailType.OUT_OF_MEMORY, outOfMemoryError);
        }
        catch (Throwable throwable) {
            L.e(throwable);
            this.fireFailEvent(FailReason.FailType.UNKNOWN, throwable);
        }
        return decodedResult;
    }

    private DecodedResult decodeImage(String string) {
        ViewScaleType viewScaleType = this.imageAware.getScaleType();
        ImageDecodingInfo imageDecodingInfo = new ImageDecodingInfo(this.memoryCacheKey, string, this.uri, this.targetSize, viewScaleType, this.getDownloader(), this.options, this.listener);
        return this.decoder.decode(imageDecodingInfo);
    }

    private boolean tryCacheImageOnDisk() {
        boolean bl2;
        L.d(LOG_CACHE_IMAGE_ON_DISK, this.memoryCacheKey);
        try {
            bl2 = this.downloadImage();
            if (bl2) {
                int n2 = this.configuration.maxImageWidthForDiskCache;
                int n3 = this.configuration.maxImageHeightForDiskCache;
                if (n2 > 0 || n3 > 0) {
                    L.d(LOG_RESIZE_CACHED_IMAGE_FILE, this.memoryCacheKey);
                    this.resizeAndSaveImage(n2, n3);
                }
            }
        }
        catch (IOException iOException) {
            L.e(iOException);
            bl2 = false;
        }
        return bl2;
    }

    private boolean downloadImage() {
        InputStream inputStream = this.getDownloader().getStream(this.uri, this.options.getExtraForDownloader());
        if (inputStream == null) {
            L.e(ERROR_NO_IMAGE_STREAM, this.memoryCacheKey);
            return false;
        }
        try {
            boolean bl2 = this.configuration.diskCache.save(this.uri, inputStream, this);
            return bl2;
        }
        finally {
            IoUtils.closeSilently(inputStream);
        }
    }

    private boolean resizeAndSaveImage(int n2, int n3) {
        boolean bl2 = false;
        File file = this.configuration.diskCache.get(this.uri);
        if (file != null && file.exists()) {
            ImageSize imageSize = new ImageSize(n2, n3);
            DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().cloneFrom(this.options).imageScaleType(ImageScaleType.IN_SAMPLE_INT).build();
            ImageDecodingInfo imageDecodingInfo = new ImageDecodingInfo(this.memoryCacheKey, ImageDownloader.Scheme.FILE.wrap(file.getAbsolutePath()), this.uri, imageSize, ViewScaleType.FIT_INSIDE, this.getDownloader(), displayImageOptions, this.listener);
            DecodedResult decodedResult = this.decoder.decode(imageDecodingInfo);
            Bitmap bitmap = null;
            if (decodedResult != null) {
                bitmap = decodedResult.mBitmap;
            }
            if (bitmap != null && this.configuration.processorForDiskCache != null) {
                L.d(LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISK, this.memoryCacheKey);
                bitmap = this.configuration.processorForDiskCache.process(bitmap);
                if (bitmap == null) {
                    L.e(ERROR_PROCESSOR_FOR_DISK_CACHE_NULL, this.memoryCacheKey);
                }
            }
            if (bitmap != null) {
                bl2 = this.configuration.diskCache.save(this.uri, bitmap);
                bitmap.recycle();
            }
        }
        return bl2;
    }

    @Override
    public boolean onBytesCopied(int n2, int n3) {
        return this.syncLoading || this.fireProgressEvent(n2, n3);
    }

    private boolean fireProgressEvent(final int n2, final int n3) {
        if (this.isTaskInterrupted() || this.isTaskNotActual()) {
            return false;
        }
        if (this.progressListener != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LoadAndDisplayImageTask.this.progressListener.onProgressUpdate(LoadAndDisplayImageTask.this.uri, LoadAndDisplayImageTask.this.imageAware.getWrappedView(), n2, n3);
                }
            };
            LoadAndDisplayImageTask.runTask(runnable, false, this.handler, this.engine);
        }
        return true;
    }

    private void fireFailEvent(FailReason.FailType failType, Throwable throwable) {
        if (this.syncLoading || this.isTaskInterrupted() || this.isTaskNotActual()) {
            return;
        }
        FireFailEventRunnable fireFailEventRunnable = new FireFailEventRunnable(this, failType, throwable);
        LoadAndDisplayImageTask.runTask(fireFailEventRunnable, false, this.handler, this.engine);
    }

    private void fireCancelEvent() {
        if (this.syncLoading || this.isTaskInterrupted()) {
            return;
        }
        FireCancelEventRunnable fireCancelEventRunnable = new FireCancelEventRunnable(this);
        LoadAndDisplayImageTask.runTask(fireCancelEventRunnable, false, this.handler, this.engine);
    }

    private ImageDownloader getDownloader() {
        ImageDownloader imageDownloader = this.engine.isNetworkDenied() ? this.networkDeniedDownloader : (this.engine.isSlowNetwork() ? this.slowNetworkDownloader : this.downloader);
        return imageDownloader;
    }

    private void checkTaskNotActual() {
        this.checkViewCollected();
        this.checkViewReused();
    }

    private boolean isTaskNotActual() {
        return this.isViewCollected() || this.isViewReused();
    }

    private void checkViewCollected() {
        if (this.isViewCollected()) {
            throw new TaskCancelledException();
        }
    }

    private boolean isViewCollected() {
        if (this.imageAware.isCollected()) {
            L.d(LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED, this.memoryCacheKey);
            return true;
        }
        return false;
    }

    private void checkViewReused() {
        if (this.isViewReused()) {
            throw new TaskCancelledException();
        }
    }

    private boolean isViewReused() {
        boolean bl2;
        String string = this.engine.getLoadingUriForView(this.imageAware);
        boolean bl3 = bl2 = !this.memoryCacheKey.equals(string);
        if (bl2) {
            L.d(LOG_TASK_CANCELLED_IMAGEAWARE_REUSED, this.memoryCacheKey);
            return true;
        }
        return false;
    }

    private void checkTaskInterrupted() {
        if (this.isTaskInterrupted()) {
            throw new TaskCancelledException();
        }
    }

    private boolean isTaskInterrupted() {
        if (Thread.interrupted()) {
            L.d(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
            return true;
        }
        return false;
    }

    String getLoadingUri() {
        return this.uri;
    }

    static void runTask(Runnable runnable, boolean bl2, Handler handler, ImageLoaderEngine imageLoaderEngine) {
        if (bl2) {
            runnable.run();
        } else if (handler == null) {
            imageLoaderEngine.fireCallback(runnable);
        } else {
            handler.post(runnable);
        }
    }

    class TaskCancelledException
    extends Exception {
        private static final long serialVersionUID = -504619855289909996L;

        TaskCancelledException() {
        }
    }

    private static class FireCancelEventRunnable
    implements Runnable {
        private WeakReference<LoadAndDisplayImageTask> weakReference;

        FireCancelEventRunnable(LoadAndDisplayImageTask loadAndDisplayImageTask) {
            this.weakReference = new WeakReference<LoadAndDisplayImageTask>(loadAndDisplayImageTask);
        }

        @Override
        public void run() {
            LoadAndDisplayImageTask loadAndDisplayImageTask = (LoadAndDisplayImageTask)this.weakReference.get();
            if (loadAndDisplayImageTask != null) {
                loadAndDisplayImageTask.listener.onLoadingCancelled(loadAndDisplayImageTask.uri, loadAndDisplayImageTask.imageAware.getWrappedView());
            }
        }
    }

    private static class FireFailEventRunnable
    implements Runnable {
        private WeakReference<LoadAndDisplayImageTask> weakReference;
        final FailReason.FailType failType;
        final Throwable failCause;

        FireFailEventRunnable(LoadAndDisplayImageTask loadAndDisplayImageTask, FailReason.FailType failType, Throwable throwable) {
            this.weakReference = new WeakReference<LoadAndDisplayImageTask>(loadAndDisplayImageTask);
            this.failCause = throwable;
            this.failType = failType;
        }

        @Override
        public void run() {
            LoadAndDisplayImageTask loadAndDisplayImageTask = (LoadAndDisplayImageTask)this.weakReference.get();
            if (loadAndDisplayImageTask != null) {
                if (loadAndDisplayImageTask.options.shouldShowImageOnFail()) {
                    loadAndDisplayImageTask.imageAware.setImageDrawable(loadAndDisplayImageTask.options.getImageOnFail(((LoadAndDisplayImageTask)loadAndDisplayImageTask).configuration.resources));
                }
                loadAndDisplayImageTask.listener.onLoadingFailed(loadAndDisplayImageTask.uri, loadAndDisplayImageTask.imageAware.getWrappedView(), new FailReason(this.failType, this.failCause));
            }
        }
    }
}

