/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core;

import android.os.Handler;
import com.kwad.sdk.core.imageloader.core.DisplayBitmapTask;
import com.kwad.sdk.core.imageloader.core.ImageLoaderEngine;
import com.kwad.sdk.core.imageloader.core.ImageLoadingInfo;
import com.kwad.sdk.core.imageloader.core.LoadAndDisplayImageTask;
import com.kwad.sdk.core.imageloader.core.assist.LoadedFrom;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.process.BitmapProcessor;
import com.kwad.sdk.core.imageloader.utils.L;

final class ProcessAndDisplayImageTask
implements Runnable {
    private static final String LOG_POSTPROCESS_IMAGE = "PostProcess image before displaying [%s]";
    private final ImageLoaderEngine engine;
    private final ImageLoadingInfo imageLoadingInfo;
    private final Handler handler;
    private final DecodedResult decodedResult;

    public ProcessAndDisplayImageTask(ImageLoaderEngine imageLoaderEngine, DecodedResult decodedResult, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.engine = imageLoaderEngine;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
        this.decodedResult = decodedResult;
    }

    @Override
    public void run() {
        L.d(LOG_POSTPROCESS_IMAGE, this.imageLoadingInfo.memoryCacheKey);
        BitmapProcessor bitmapProcessor = this.imageLoadingInfo.options.getPostProcessor();
        this.decodedResult.mBitmap = bitmapProcessor.process(this.decodedResult.mBitmap);
        DisplayBitmapTask displayBitmapTask = new DisplayBitmapTask(this.decodedResult, this.imageLoadingInfo, this.engine, LoadedFrom.MEMORY_CACHE);
        LoadAndDisplayImageTask.runTask(displayBitmapTask, this.imageLoadingInfo.options.isSyncLoading(), this.handler, this.engine);
    }
}

