/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.decode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import com.kwad.sdk.core.imageloader.core.assist.ImageScaleType;
import com.kwad.sdk.core.imageloader.core.assist.ImageSize;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.decode.ImageDecoder;
import com.kwad.sdk.core.imageloader.core.decode.ImageDecodingInfo;
import com.kwad.sdk.core.imageloader.core.download.ImageDownloader;
import com.kwad.sdk.core.imageloader.utils.ImageSizeUtils;
import com.kwad.sdk.core.imageloader.utils.IoUtils;
import com.kwad.sdk.core.imageloader.utils.L;
import java.io.IOException;
import java.io.InputStream;

public class BaseImageDecoder
implements ImageDecoder {
    protected static final String LOG_SUBSAMPLE_IMAGE = "Subsample original image (%1$s) to %2$s (scale = %3$d) [%4$s]";
    protected static final String LOG_SCALE_IMAGE = "Scale subsampled image (%1$s) to %2$s (scale = %3$.5f) [%4$s]";
    protected static final String LOG_ROTATE_IMAGE = "Rotate image on %1$d\u00b0 [%2$s]";
    protected static final String LOG_FLIP_IMAGE = "Flip image horizontally [%s]";
    protected static final String ERROR_NO_IMAGE_STREAM = "No stream for image [%s]";
    protected static final String ERROR_CANT_DECODE_IMAGE = "Image can't be decoded [%s]";
    protected final boolean loggingEnabled;

    public BaseImageDecoder(boolean bl2) {
        this.loggingEnabled = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecodedResult decode(ImageDecodingInfo imageDecodingInfo) {
        ImageFileInfo imageFileInfo;
        DecodedResult decodedResult = new DecodedResult();
        InputStream inputStream = this.getImageStream(imageDecodingInfo);
        if (inputStream == null) {
            L.e(ERROR_NO_IMAGE_STREAM, imageDecodingInfo.getImageKey());
            return null;
        }
        try {
            if (imageDecodingInfo.getLoadListener() != null && imageDecodingInfo.getLoadListener().onDecode(imageDecodingInfo.getImageUri(), inputStream, decodedResult)) {
                DecodedResult decodedResult2 = decodedResult;
                return decodedResult2;
            }
            imageFileInfo = this.defineImageSizeAndRotation(inputStream, imageDecodingInfo);
            inputStream = this.resetStream(inputStream, imageDecodingInfo);
            BitmapFactory.Options options = this.prepareDecodingOptions(imageFileInfo.imageSize, imageDecodingInfo);
            decodedResult.mBitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        finally {
            IoUtils.closeSilently(inputStream);
        }
        if (decodedResult.mBitmap == null && decodedResult.mFrameSequence == null) {
            L.e(ERROR_CANT_DECODE_IMAGE, imageDecodingInfo.getImageKey());
        } else {
            decodedResult.mBitmap = this.considerExactScaleAndOrientatiton(decodedResult.mBitmap, imageDecodingInfo, imageFileInfo.exif.rotation, imageFileInfo.exif.flipHorizontal);
        }
        return decodedResult;
    }

    public InputStream getImageStream(ImageDecodingInfo imageDecodingInfo) {
        return imageDecodingInfo.getDownloader().getStream(imageDecodingInfo.getImageUri(), imageDecodingInfo.getExtraForDownloader());
    }

    protected ImageFileInfo defineImageSizeAndRotation(InputStream inputStream, ImageDecodingInfo imageDecodingInfo) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        String string = imageDecodingInfo.getImageUri();
        ExifInfo exifInfo = imageDecodingInfo.shouldConsiderExifParams() && this.canDefineExifParams(string, options.outMimeType) ? this.defineExifOrientation(string) : new ExifInfo();
        return new ImageFileInfo(new ImageSize(options.outWidth, options.outHeight, exifInfo.rotation), exifInfo);
    }

    private boolean canDefineExifParams(String string, String string2) {
        return "image/jpeg".equalsIgnoreCase(string2) && ImageDownloader.Scheme.ofUri(string) == ImageDownloader.Scheme.FILE;
    }

    protected ExifInfo defineExifOrientation(String string) {
        int n2 = 0;
        boolean bl2 = false;
        try {
            ExifInterface exifInterface = new ExifInterface(ImageDownloader.Scheme.FILE.crop(string));
            int n3 = exifInterface.getAttributeInt("Orientation", 1);
            switch (n3) {
                case 2: {
                    bl2 = true;
                }
                case 1: {
                    n2 = 0;
                    break;
                }
                case 7: {
                    bl2 = true;
                }
                case 6: {
                    n2 = 90;
                    break;
                }
                case 4: {
                    bl2 = true;
                }
                case 3: {
                    n2 = 180;
                    break;
                }
                case 5: {
                    bl2 = true;
                }
                case 8: {
                    n2 = 270;
                }
            }
        }
        catch (IOException iOException) {
            L.w("Can't read EXIF tags from file [%s]", string);
        }
        return new ExifInfo(n2, bl2);
    }

    protected BitmapFactory.Options prepareDecodingOptions(ImageSize imageSize, ImageDecodingInfo imageDecodingInfo) {
        ImageSize imageSize2;
        int n2;
        ImageScaleType imageScaleType = imageDecodingInfo.getImageScaleType();
        if (imageScaleType == ImageScaleType.NONE) {
            n2 = 1;
        } else if (imageScaleType == ImageScaleType.NONE_SAFE) {
            n2 = ImageSizeUtils.computeMinImageSampleSize(imageSize);
        } else {
            imageSize2 = imageDecodingInfo.getTargetSize();
            boolean bl2 = imageScaleType == ImageScaleType.IN_SAMPLE_POWER_OF_2;
            n2 = ImageSizeUtils.computeImageSampleSize(imageSize, imageSize2, imageDecodingInfo.getViewScaleType(), bl2);
        }
        if (n2 > 1 && this.loggingEnabled) {
            L.d(LOG_SUBSAMPLE_IMAGE, imageSize, imageSize.scaleDown(n2), n2, imageDecodingInfo.getImageKey());
        }
        imageSize2 = imageDecodingInfo.getDecodingOptions();
        ((BitmapFactory.Options)imageSize2).inSampleSize = n2;
        return imageSize2;
    }

    protected InputStream resetStream(InputStream inputStream, ImageDecodingInfo imageDecodingInfo) {
        if (inputStream.markSupported()) {
            try {
                inputStream.reset();
                return inputStream;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IoUtils.closeSilently(inputStream);
        return this.getImageStream(imageDecodingInfo);
    }

    protected Bitmap considerExactScaleAndOrientatiton(Bitmap bitmap, ImageDecodingInfo imageDecodingInfo, int n2, boolean bl2) {
        ImageSize imageSize;
        float f2;
        Matrix matrix = new Matrix();
        ImageScaleType imageScaleType = imageDecodingInfo.getImageScaleType();
        if ((imageScaleType == ImageScaleType.EXACTLY || imageScaleType == ImageScaleType.EXACTLY_STRETCHED) && Float.compare(f2 = ImageSizeUtils.computeImageScale(imageSize = new ImageSize(bitmap.getWidth(), bitmap.getHeight(), n2), imageDecodingInfo.getTargetSize(), imageDecodingInfo.getViewScaleType(), imageScaleType == ImageScaleType.EXACTLY_STRETCHED), 1.0f) != 0) {
            matrix.setScale(f2, f2);
            if (this.loggingEnabled) {
                L.d(LOG_SCALE_IMAGE, imageSize, imageSize.scale(f2), Float.valueOf(f2), imageDecodingInfo.getImageKey());
            }
        }
        if (bl2) {
            matrix.postScale(-1.0f, 1.0f);
            if (this.loggingEnabled) {
                L.d(LOG_FLIP_IMAGE, imageDecodingInfo.getImageKey());
            }
        }
        if (n2 != 0) {
            matrix.postRotate((float)n2);
            if (this.loggingEnabled) {
                L.d(LOG_ROTATE_IMAGE, n2, imageDecodingInfo.getImageKey());
            }
        }
        if ((imageSize = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true)) != bitmap) {
            bitmap.recycle();
        }
        return imageSize;
    }

    protected static class ImageFileInfo {
        public final ImageSize imageSize;
        public final ExifInfo exif;

        protected ImageFileInfo(ImageSize imageSize, ExifInfo exifInfo) {
            this.imageSize = imageSize;
            this.exif = exifInfo;
        }
    }

    protected static class ExifInfo {
        public final int rotation;
        public final boolean flipHorizontal;

        protected ExifInfo() {
            this.rotation = 0;
            this.flipHorizontal = false;
        }

        protected ExifInfo(int n2, boolean bl2) {
            this.rotation = n2;
            this.flipHorizontal = bl2;
        }
    }
}

