/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.display;

import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.kwad.sdk.core.imageloader.core.assist.LoadedFrom;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.display.BitmapDisplayer;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageAware;

public class FadeInBitmapDisplayer
implements BitmapDisplayer {
    private final int durationMillis;
    private final boolean animateFromNetwork;
    private final boolean animateFromDisk;
    private final boolean animateFromMemory;

    public FadeInBitmapDisplayer(int n2) {
        this(n2, true, true, true);
    }

    public FadeInBitmapDisplayer(int n2, boolean bl2, boolean bl3, boolean bl4) {
        this.durationMillis = n2;
        this.animateFromNetwork = bl2;
        this.animateFromDisk = bl3;
        this.animateFromMemory = bl4;
    }

    @Override
    public void display(DecodedResult decodedResult, ImageAware imageAware, LoadedFrom loadedFrom) {
        imageAware.setImageBitmap(decodedResult.mBitmap);
        if (this.animateFromNetwork && loadedFrom == LoadedFrom.NETWORK || this.animateFromDisk && loadedFrom == LoadedFrom.DISC_CACHE || this.animateFromMemory && loadedFrom == LoadedFrom.MEMORY_CACHE) {
            FadeInBitmapDisplayer.animate(imageAware.getWrappedView(), this.durationMillis);
        }
    }

    public static void animate(View view, int n2) {
        if (view != null) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation.setDuration((long)n2);
            alphaAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
            view.startAnimation((Animation)alphaAnimation);
        }
    }
}

