/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.display;

import android.graphics.Bitmap;
import android.graphics.ComposeShader;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import com.kwad.sdk.core.imageloader.core.assist.LoadedFrom;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import com.kwad.sdk.core.imageloader.core.display.RoundedBitmapDisplayer;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageAware;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageViewAware;

public class RoundedVignetteBitmapDisplayer
extends RoundedBitmapDisplayer {
    public RoundedVignetteBitmapDisplayer(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    public void display(DecodedResult decodedResult, ImageAware imageAware, LoadedFrom loadedFrom) {
        if (!(imageAware instanceof ImageViewAware)) {
            throw new IllegalArgumentException("ImageAware should wrap ImageView. ImageViewAware is expected.");
        }
        imageAware.setImageDrawable(new RoundedVignetteDrawable(decodedResult.mBitmap, this.cornerRadius, this.margin));
    }

    protected static class RoundedVignetteDrawable
    extends RoundedBitmapDisplayer.RoundedDrawable {
        RoundedVignetteDrawable(Bitmap bitmap, int n2, int n3) {
            super(bitmap, n2, n3);
        }

        @Override
        protected void onBoundsChange(Rect rect) {
            super.onBoundsChange(rect);
            RadialGradient radialGradient = new RadialGradient(this.mRect.centerX(), this.mRect.centerY() * 1.0f / 0.7f, this.mRect.centerX() * 1.3f, new int[]{0, 0, 0x7F000000}, new float[]{0.0f, 0.7f, 1.0f}, Shader.TileMode.CLAMP);
            Matrix matrix = new Matrix();
            matrix.setScale(1.0f, 0.7f);
            radialGradient.setLocalMatrix(matrix);
            this.paint.setShader((Shader)new ComposeShader((Shader)this.bitmapShader, (Shader)radialGradient, PorterDuff.Mode.SRC_OVER));
        }
    }
}

