/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.download;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import com.kwad.sdk.core.imageloader.core.assist.ContentLengthInputStream;
import com.kwad.sdk.core.imageloader.core.download.ImageDownloader;
import com.kwad.sdk.core.imageloader.utils.IoUtils;
import com.kwad.sdk.core.network.k;
import com.kwad.sdk.core.network.l;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class BaseImageDownloader
implements ImageDownloader {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 20000;
    protected static final int BUFFER_SIZE = 32768;
    protected static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    protected static final int MAX_REDIRECT_COUNT = 5;
    private static final String ERROR_UNSUPPORTED_SCHEME = "UIL doesn't support scheme(protocol) by default [%s]. You should implement this support yourself (BaseImageDownloader.getStreamFromOtherSource(...))";
    protected final Context context;
    protected final int connectTimeout;
    protected final int readTimeout;

    public BaseImageDownloader(Context context) {
        this(context, 5000, 20000);
    }

    public BaseImageDownloader(Context context, int n2, int n3) {
        this.context = context.getApplicationContext();
        this.connectTimeout = n2;
        this.readTimeout = n3;
    }

    @Override
    public InputStream getStream(String string2, Object object) {
        switch (ImageDownloader.Scheme.ofUri(string2)) {
            case HTTP: 
            case HTTPS: {
                return this.getStreamFromNetwork(string2, object);
            }
            case FILE: {
                return this.getStreamFromFile(string2, object);
            }
            case CONTENT: {
                return this.getStreamFromContent(string2, object);
            }
            case ASSETS: {
                return this.getStreamFromAssets(string2, object);
            }
            case DRAWABLE: {
                return this.getStreamFromDrawable(string2, object);
            }
        }
        return this.getStreamFromOtherSource(string2, object);
    }

    protected InputStream getStreamFromNetwork(String string2, Object object) {
        InputStream inputStream;
        HttpURLConnection httpURLConnection = this.createConnection(string2, object);
        for (int i2 = 0; httpURLConnection.getResponseCode() / 100 == 3 && i2 < 5; ++i2) {
            httpURLConnection = this.createConnection(httpURLConnection.getHeaderField("Location"), object);
        }
        try {
            inputStream = httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            IoUtils.readAndCloseStream(httpURLConnection.getErrorStream());
            throw iOException;
        }
        if (!this.shouldBeProcessed(httpURLConnection)) {
            IoUtils.closeSilently(inputStream);
            throw new IOException("Image request failed with response code " + httpURLConnection.getResponseCode());
        }
        return new ContentLengthInputStream(new BufferedInputStream(inputStream, 32768), httpURLConnection.getContentLength());
    }

    protected boolean shouldBeProcessed(HttpURLConnection httpURLConnection) {
        return httpURLConnection.getResponseCode() == 200;
    }

    protected HttpURLConnection createConnection(String string2, Object object) {
        String string3 = Uri.encode((String)string2, (String)ALLOWED_URI_CHARS);
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string3).openConnection();
        l.a(httpURLConnection);
        httpURLConnection.setRequestProperty("User-Agent", k.a());
        httpURLConnection.setConnectTimeout(this.connectTimeout);
        httpURLConnection.setReadTimeout(this.readTimeout);
        return httpURLConnection;
    }

    protected InputStream getStreamFromFile(String string2, Object object) {
        String string3 = ImageDownloader.Scheme.FILE.crop(string2);
        if (this.isVideoFileUri(string2)) {
            return this.getVideoThumbnailStream(string3);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string3), 32768);
        return new ContentLengthInputStream(bufferedInputStream, (int)new File(string3).length());
    }

    @TargetApi(value=8)
    private InputStream getVideoThumbnailStream(String string2) {
        Bitmap bitmap;
        if (Build.VERSION.SDK_INT >= 8 && (bitmap = ThumbnailUtils.createVideoThumbnail((String)string2, (int)2)) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream);
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        return null;
    }

    protected InputStream getStreamFromContent(String string2, Object object) {
        Long l2;
        Bitmap bitmap;
        ContentResolver contentResolver = this.context.getContentResolver();
        Uri uri = Uri.parse((String)string2);
        if (this.isVideoContentUri(uri) && (bitmap = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)(l2 = Long.valueOf(uri.getLastPathSegment())), (int)1, null)) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream);
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        return contentResolver.openInputStream(uri);
    }

    protected InputStream getStreamFromAssets(String string2, Object object) {
        String string3 = ImageDownloader.Scheme.ASSETS.crop(string2);
        return this.context.getAssets().open(string3);
    }

    protected InputStream getStreamFromDrawable(String string2, Object object) {
        String string3 = ImageDownloader.Scheme.DRAWABLE.crop(string2);
        int n2 = Integer.parseInt(string3);
        return this.context.getResources().openRawResource(n2);
    }

    protected InputStream getStreamFromOtherSource(String string2, Object object) {
        throw new UnsupportedOperationException(String.format(ERROR_UNSUPPORTED_SCHEME, string2));
    }

    private boolean isVideoContentUri(Uri uri) {
        String string2 = this.context.getContentResolver().getType(uri);
        return string2 != null && string2.startsWith("video/");
    }

    private boolean isVideoFileUri(String string2) {
        String string3 = MimeTypeMap.getFileExtensionFromUrl((String)string2);
        String string4 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
        return string4 != null && string4.startsWith("video/");
    }
}

