/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.download;

import java.io.InputStream;
import java.util.Locale;

public interface ImageDownloader {
    public InputStream getStream(String var1, Object var2);

    public static enum Scheme {
        HTTP("http"),
        HTTPS("https"),
        FILE("file"),
        CONTENT("content"),
        ASSETS("assets"),
        DRAWABLE("drawable"),
        UNKNOWN("");

        private String scheme;
        private String uriPrefix;

        private Scheme(String string3) {
            this.scheme = string3;
            this.uriPrefix = string3 + "://";
        }

        public static Scheme ofUri(String string2) {
            if (string2 != null) {
                for (Scheme scheme : Scheme.values()) {
                    if (!scheme.belongsTo(string2)) continue;
                    return scheme;
                }
            }
            return UNKNOWN;
        }

        private boolean belongsTo(String string2) {
            return string2.toLowerCase(Locale.US).startsWith(this.uriPrefix);
        }

        public String wrap(String string2) {
            return this.uriPrefix + string2;
        }

        public String crop(String string2) {
            if (!this.belongsTo(string2)) {
                throw new IllegalArgumentException(String.format("URI [%1$s] doesn't have expected scheme [%2$s]", string2, this.scheme));
            }
            return string2.substring(this.uriPrefix.length());
        }
    }
}

