/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.core.imageaware;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import com.kwad.sdk.core.imageloader.core.assist.ImageSize;
import com.kwad.sdk.core.imageloader.core.assist.ViewScaleType;
import com.kwad.sdk.core.imageloader.core.imageaware.ImageAware;

public class NonViewAware
implements ImageAware {
    protected final String imageUri;
    protected final ImageSize imageSize;
    protected final ViewScaleType scaleType;

    public NonViewAware(ImageSize imageSize, ViewScaleType viewScaleType) {
        this(null, imageSize, viewScaleType);
    }

    public NonViewAware(String string, ImageSize imageSize, ViewScaleType viewScaleType) {
        if (imageSize == null) {
            throw new IllegalArgumentException("imageSize must not be null");
        }
        if (viewScaleType == null) {
            throw new IllegalArgumentException("scaleType must not be null");
        }
        this.imageUri = string;
        this.imageSize = imageSize;
        this.scaleType = viewScaleType;
    }

    @Override
    public int getWidth() {
        return this.imageSize.getWidth();
    }

    @Override
    public int getHeight() {
        return this.imageSize.getHeight();
    }

    @Override
    public ViewScaleType getScaleType() {
        return this.scaleType;
    }

    @Override
    public View getWrappedView() {
        return null;
    }

    @Override
    public boolean isCollected() {
        return false;
    }

    @Override
    public int getId() {
        return TextUtils.isEmpty((CharSequence)this.imageUri) ? super.hashCode() : this.imageUri.hashCode();
    }

    @Override
    public boolean setImageDrawable(Drawable drawable2) {
        return true;
    }

    @Override
    public boolean setImageBitmap(Bitmap bitmap) {
        return true;
    }
}

