/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.utils;

import com.kwad.sdk.core.d.a;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public final class IoUtils {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final int DEFAULT_IMAGE_TOTAL_SIZE = 512000;
    public static final int CONTINUE_LOADING_PERCENTAGE = 75;

    private IoUtils() {
    }

    public static boolean copyStream(InputStream inputStream, OutputStream outputStream, CopyListener copyListener) {
        return IoUtils.copyStream(inputStream, outputStream, copyListener, 32768);
    }

    public static boolean copyStream(InputStream inputStream, OutputStream outputStream, CopyListener copyListener, int n2) {
        int n3;
        int n4 = 0;
        int n5 = inputStream.available();
        if (n5 <= 0) {
            n5 = 512000;
        }
        byte[] byArray = new byte[n2];
        if (IoUtils.shouldStopLoading(copyListener, n4, n5)) {
            return false;
        }
        while ((n3 = inputStream.read(byArray, 0, n2)) != -1) {
            outputStream.write(byArray, 0, n3);
            if (!IoUtils.shouldStopLoading(copyListener, n4 += n3, n5)) continue;
            return false;
        }
        outputStream.flush();
        return true;
    }

    private static boolean shouldStopLoading(CopyListener copyListener, int n2, int n3) {
        boolean bl2;
        return copyListener != null && !(bl2 = copyListener.onBytesCopied(n2, n3)) && 100 * n2 / n3 < 75;
    }

    public static void readAndCloseStream(InputStream inputStream) {
        byte[] byArray = new byte[32768];
        try {
            while (inputStream.read(byArray, 0, 32768) != -1) {
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IoUtils.closeSilently(inputStream);
        }
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStreamToString(InputStream inputStream) {
        int n2 = 1024;
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            while (true) {
                int n3 = 0;
                n3 = ((Reader)inputStreamReader).read(cArray, 0, cArray.length);
                if (n3 < 0) {
                    break;
                }
                stringBuilder.append(cArray, 0, n3);
            }
        }
        catch (Exception exception) {
            a.a(exception);
            String string2 = null;
            return string2;
        }
        finally {
            if (inputStreamReader != null) {
                IoUtils.closeSilently(inputStreamReader);
            }
        }
        return stringBuilder.toString();
    }

    public static interface CopyListener {
        public boolean onBytesCopied(int var1, int var2);
    }
}

