/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.imageloader.utils;

import com.kwad.sdk.core.imageloader.cache.memory.MemoryCache;
import com.kwad.sdk.core.imageloader.core.assist.ImageSize;
import com.kwad.sdk.core.imageloader.core.decode.DecodedResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class MemoryCacheUtils {
    private static final String URI_AND_SIZE_SEPARATOR = "_";
    private static final String WIDTH_AND_HEIGHT_SEPARATOR = "x";

    private MemoryCacheUtils() {
    }

    public static String generateKey(String string, ImageSize imageSize) {
        return string + URI_AND_SIZE_SEPARATOR + imageSize.getWidth() + WIDTH_AND_HEIGHT_SEPARATOR + imageSize.getHeight();
    }

    public static Comparator<String> createFuzzyKeyComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                String string3 = string.substring(0, string.lastIndexOf(MemoryCacheUtils.URI_AND_SIZE_SEPARATOR));
                String string4 = string2.substring(0, string2.lastIndexOf(MemoryCacheUtils.URI_AND_SIZE_SEPARATOR));
                return string3.compareTo(string4);
            }
        };
    }

    public static List<DecodedResult> findCachedBitmapsForImageUri(String string, MemoryCache memoryCache) {
        ArrayList<DecodedResult> arrayList = new ArrayList<DecodedResult>();
        for (String string2 : memoryCache.keys()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(memoryCache.get(string2));
        }
        return arrayList;
    }

    public static List<String> findCacheKeysForImageUri(String string, MemoryCache memoryCache) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : memoryCache.keys()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static void removeFromCache(String string, MemoryCache memoryCache) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : memoryCache.keys()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        for (String string2 : arrayList) {
            memoryCache.remove(string2);
        }
    }
}

