/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.core.page;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Keep;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import com.kwad.sdk.KsAdSDKImpl;
import com.kwad.sdk.api.core.KsAdSdkDynamicImpl;
import com.kwad.sdk.api.core.ResContext;
import com.kwad.sdk.api.loader.Wrapper;
import com.kwad.sdk.api.proxy.app.AdWebViewActivity;
import com.kwad.sdk.c.a;
import com.kwad.sdk.core.config.c;
import com.kwad.sdk.core.page.b;
import com.kwad.sdk.core.page.widget.b;
import com.kwad.sdk.core.response.model.AdTemplate;
import com.kwad.sdk.d;
import com.kwad.sdk.plugin.f;
import org.json.JSONObject;

@KsAdSdkDynamicImpl(value=AdWebViewActivity.class)
@Keep
public class AdWebViewActivityProxy
extends a
implements b.a {
    private static final String TAG = "AdWebViewActivityProxy";
    public static final String KEY_TEMPLATE = "key_template_json";
    public static final String KEY_MINI_WINDOW = "key_mini_window";
    private boolean mIsVPlusShown = false;
    public static final String KEY_LANDING_PAGE_TYPE = "key_landing_page_type";
    private AdTemplate mAdTemplate;
    private Context mContext;
    private b landingPageViewHelper;

    public static void launch(Context context, AdTemplate adTemplate) {
        AdWebViewActivityProxy.launch(context, adTemplate, 0);
    }

    public static void launch(Context context, AdTemplate adTemplate, int n2) {
        if (context == null || adTemplate == null) {
            return;
        }
        KsAdSDKImpl.putComponentProxy(AdWebViewActivity.class, AdWebViewActivityProxy.class);
        Intent intent = new Intent(context, AdWebViewActivity.class);
        intent.addFlags(0x10000000);
        intent.putExtra(KEY_TEMPLATE, adTemplate.toJson().toString());
        intent.putExtra(KEY_LANDING_PAGE_TYPE, n2);
        if (adTemplate.mMiniWindowId != null) {
            intent.putExtra(KEY_MINI_WINDOW, adTemplate.mMiniWindowId);
        }
        context.startActivity(intent);
        if (context instanceof ResContext) {
            context = ((ResContext)context).getDelegatedContext();
        }
        if (context instanceof Activity) {
            ((Activity)context).overridePendingTransition(0, 0);
        }
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mContext = Wrapper.wrapContextIfNeed((Context)this.getActivity());
        String string = this.getIntent().getStringExtra(KEY_TEMPLATE);
        int n2 = this.getIntent().getIntExtra(KEY_LANDING_PAGE_TYPE, 0);
        try {
            AdTemplate adTemplate = new AdTemplate();
            adTemplate.parseJson(new JSONObject(string));
            this.mAdTemplate = adTemplate;
        }
        catch (Throwable throwable) {
            com.kwad.sdk.core.d.a.a(throwable);
        }
        if (this.mAdTemplate != null) {
            this.landingPageViewHelper = new b(this.mContext, this.mAdTemplate, n2, true);
            this.landingPageViewHelper.a(this);
            this.landingPageViewHelper.c();
            this.setContentView(this.landingPageViewHelper.a());
        } else {
            this.finish();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.landingPageViewHelper != null) {
            this.landingPageViewHelper.d();
        }
        if (!this.mIsVPlusShown) {
            this.showMiniWindowIfNeeded();
            this.mIsVPlusShown = true;
        }
    }

    private void showMiniWindowIfNeeded() {
        final String string = this.getIntent().getStringExtra(KEY_MINI_WINDOW);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Handler handler = new Handler();
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Rect rect = new Rect();
                    DisplayMetrics displayMetrics = AdWebViewActivityProxy.this.getActivity().getResources().getDisplayMetrics();
                    rect.right = displayMetrics.widthPixels;
                    rect.left = rect.right - displayMetrics.widthPixels / 4;
                    rect.bottom = (int)((float)displayMetrics.heightPixels * 0.83f);
                    rect.top = rect.bottom - displayMetrics.widthPixels / 4 * 16 / 9;
                    com.kwad.sdk.splashscreen.a a2 = new com.kwad.sdk.splashscreen.a((Context)AdWebViewActivityProxy.this.getActivity(), string, false, null);
                    a2.a(rect);
                }
            });
        }
    }

    @Override
    public void onPause() {
        if (this.landingPageViewHelper != null) {
            this.landingPageViewHelper.e();
        }
        this.overridePendingTransition(0, 0);
    }

    @Override
    protected void onDestroy() {
        if (this.landingPageViewHelper != null) {
            this.landingPageViewHelper.f();
        }
        super.onDestroy();
        if (this.mAdTemplate.interactLandingPageShowing) {
            this.mAdTemplate.interactLandingPageShowing = false;
        }
    }

    @Override
    public void onBackPressed() {
        if (this.isAggregateAdOpen()) {
            com.kwad.sdk.plugin.b b2 = f.a(com.kwad.sdk.plugin.b.class);
            if (b2 != null) {
                b2.a((Context)this.getActivity(), this.mAdTemplate, 2);
            }
            this.finish();
        } else if (this.isFormAdExitInterceptEnable()) {
            com.kwad.sdk.core.page.widget.b b3 = new com.kwad.sdk.core.page.widget.b((Context)this.getActivity(), new b.a(){

                @Override
                public void a(DialogInterface dialogInterface) {
                    com.kwad.sdk.core.report.a.d(AdWebViewActivityProxy.this.mAdTemplate, 104);
                    dialogInterface.dismiss();
                }

                @Override
                public void b(DialogInterface dialogInterface) {
                    AdWebViewActivityProxy.super.onBackPressed();
                    com.kwad.sdk.core.report.a.d(AdWebViewActivityProxy.this.mAdTemplate, 105);
                }

                @Override
                public void c(DialogInterface dialogInterface) {
                    com.kwad.sdk.core.report.a.d(AdWebViewActivityProxy.this.mAdTemplate, 106);
                    dialogInterface.dismiss();
                }
            });
            com.kwad.sdk.core.report.a.c(this.mAdTemplate, 103, null);
            b3.show();
        } else {
            super.onBackPressed();
        }
    }

    private boolean isFormAdExitInterceptEnable() {
        if (this.mAdTemplate == null) {
            return false;
        }
        if (c.D() && this.mAdTemplate.mIsFromContent) {
            return true;
        }
        return c.E() && !this.mAdTemplate.mIsFromContent;
    }

    private boolean isAggregateAdOpen() {
        return d.a == 2 && c.p() && !TextUtils.isEmpty((CharSequence)com.kwad.sdk.core.response.b.c.p(this.mAdTemplate)) && this.mAdTemplate != null && this.mAdTemplate.mIsFromContent;
    }

    @Override
    protected String getPageName() {
        return TAG;
    }

    @Override
    public void onBackBtnClicked(View view) {
        this.onBackPressed();
    }

    @Override
    public void onCloseBtnClicked(View view) {
        if (this.isAggregateAdOpen()) {
            com.kwad.sdk.plugin.b b2 = f.a(com.kwad.sdk.plugin.b.class);
            if (b2 != null) {
                b2.a((Context)this.getActivity(), this.mAdTemplate, 2);
            }
            this.finish();
        } else if (this.isFormAdExitInterceptEnable()) {
            com.kwad.sdk.core.page.widget.b b3 = new com.kwad.sdk.core.page.widget.b((Context)this.getActivity(), new b.a(){

                @Override
                public void a(DialogInterface dialogInterface) {
                    com.kwad.sdk.core.report.a.d(AdWebViewActivityProxy.this.mAdTemplate, 104);
                    dialogInterface.dismiss();
                }

                @Override
                public void b(DialogInterface dialogInterface) {
                    AdWebViewActivityProxy.this.finish();
                    com.kwad.sdk.core.report.a.d(AdWebViewActivityProxy.this.mAdTemplate, 105);
                }

                @Override
                public void c(DialogInterface dialogInterface) {
                    com.kwad.sdk.core.report.a.d(AdWebViewActivityProxy.this.mAdTemplate, 106);
                    dialogInterface.dismiss();
                }
            });
            com.kwad.sdk.core.report.a.c(this.mAdTemplate, 103, null);
            b3.show();
        } else {
            this.finish();
        }
    }
}

