/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.crash.model.message;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.kwad.sdk.core.b;
import com.kwad.sdk.core.d.a;
import com.kwad.sdk.crash.model.message.JavaExceptionMessage;
import com.kwad.sdk.crash.utils.i;
import com.kwad.sdk.crash.utils.j;
import com.kwad.sdk.utils.q;
import java.io.Serializable;
import org.json.JSONObject;

public abstract class ExceptionMessage
implements b,
Serializable {
    private static final long serialVersionUID = -5338556142957298914L;
    public String mCrashDetail = "Unknown";
    public String mMemoryInfo = "Unknown";
    public String mDiskInfo = "Unknown";
    public String mProcessName = "Unknown";
    public int mExceptionType = 0;
    public String mCrashType = this.getTypeCommon();
    public String mThreadName = "Unknown";
    public String mIsAppOnForeground = "Unknown";
    public String mLogUUID = "Unknown";
    public String mVirtualApp = "Unknown";
    public String mCustomMsg = "Unknown";
    public String mThreadOverflow = "Unknown";
    public String mFdOverflow = "Unknown";
    public String mTaskId = "Unknown";
    public String mErrorMessage = "";
    public long mCurrentTimeStamp;
    public long mUsageTimeMills;
    public int mPid;
    public int mTid;
    public String mVersionCode = "Unknown";
    public boolean mVersionConflict = false;
    public String mAppVersionBeforeLastUpload = "Unknown";
    public String mJNIError = "";
    public String mGCInfo = "";
    public String mLockInfo = "";
    public String mMonitorInfo = "";
    public String mSlowLooper = "";
    public String mSlowOperation = "";
    public String mBuildConfigInfo = "";
    public String mAbi = "Unknown";

    protected abstract String getTypePrefix();

    public final String getTypeCommon() {
        return this.getTypePrefix() + "COMMON";
    }

    public final String getTypeHeapOOM() {
        return this.getTypePrefix() + "HEAP_OOM";
    }

    public final String getTypeThreadOOM() {
        return this.getTypePrefix() + "THREAD_OOM";
    }

    public final String getTypeFdOOM() {
        return this.getTypePrefix() + "FD_OOM";
    }

    @Override
    public void parseJson(@Nullable JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        this.mCrashDetail = jSONObject.optString("mCrashDetail");
        this.mMemoryInfo = jSONObject.optString("mMemoryInfo");
        this.mDiskInfo = jSONObject.optString("mDiskInfo");
        this.mProcessName = jSONObject.optString("mProcessName");
        this.mCrashType = jSONObject.optString("mCrashType");
        this.mThreadName = jSONObject.optString("mThreadName");
        this.mIsAppOnForeground = jSONObject.optString("mIsAppOnForeground");
        this.mLogUUID = jSONObject.optString("mLogUUID");
        this.mVirtualApp = jSONObject.optString("mVirtualApp");
        this.mCustomMsg = jSONObject.optString("mCustomMsg");
        this.mThreadOverflow = jSONObject.optString("mThreadOverflow");
        this.mFdOverflow = jSONObject.optString("mFdOverflow");
        this.mTaskId = jSONObject.optString("mTaskId");
        this.mErrorMessage = jSONObject.optString("mErrorMessage");
        this.mCurrentTimeStamp = jSONObject.optLong("mCurrentTimeStamp");
        this.mUsageTimeMills = jSONObject.optLong("mUsageTimeMills");
        this.mPid = jSONObject.optInt("mPid");
        this.mTid = jSONObject.optInt("mTid");
        this.mVersionCode = jSONObject.optString("mVersionCode");
        this.mVersionConflict = jSONObject.optBoolean("mVersionConflict");
        this.mAppVersionBeforeLastUpload = jSONObject.optString("mAppVersionBeforeLastUpload");
        this.mJNIError = jSONObject.optString("mJNIError");
        this.mGCInfo = jSONObject.optString("mGCInfo");
        this.mLockInfo = jSONObject.optString("mLockInfo");
        this.mMonitorInfo = jSONObject.optString("mMonitorInfo");
        this.mSlowLooper = jSONObject.optString("mSlowLooper");
        this.mSlowOperation = jSONObject.optString("mSlowOperation");
        this.mBuildConfigInfo = jSONObject.optString("mBuildConfigInfo");
        this.mAbi = jSONObject.optString("mAbi");
    }

    @Override
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        q.a(jSONObject, "mCrashDetail", this.mCrashDetail);
        q.a(jSONObject, "mMemoryInfo", this.mMemoryInfo);
        q.a(jSONObject, "mDiskInfo", this.mDiskInfo);
        q.a(jSONObject, "mProcessName", this.mProcessName);
        q.a(jSONObject, "mCrashType", this.mCrashType);
        q.a(jSONObject, "mThreadName", this.mThreadName);
        q.a(jSONObject, "mIsAppOnForeground", this.mIsAppOnForeground);
        q.a(jSONObject, "mLogUUID", this.mLogUUID);
        q.a(jSONObject, "mVirtualApp", this.mVirtualApp);
        q.a(jSONObject, "mCustomMsg", this.mCustomMsg);
        q.a(jSONObject, "mThreadOverflow", this.mThreadOverflow);
        q.a(jSONObject, "mFdOverflow", this.mFdOverflow);
        q.a(jSONObject, "mTaskId", this.mTaskId);
        q.a(jSONObject, "mErrorMessage", this.mErrorMessage);
        q.a(jSONObject, "mCurrentTimeStamp", this.mCurrentTimeStamp);
        q.a(jSONObject, "mUsageTimeMills", this.mUsageTimeMills);
        q.a(jSONObject, "mPid", this.mPid);
        q.a(jSONObject, "mTid", this.mTid);
        q.a(jSONObject, "mVersionCode", this.mVersionCode);
        q.a(jSONObject, "mVersionConflict", this.mVersionConflict);
        q.a(jSONObject, "mAppVersionBeforeLastUpload", this.mAppVersionBeforeLastUpload);
        q.a(jSONObject, "mJNIError", this.mJNIError);
        q.a(jSONObject, "mGCInfo", this.mGCInfo);
        q.a(jSONObject, "mLockInfo", this.mLockInfo);
        q.a(jSONObject, "mMonitorInfo", this.mMonitorInfo);
        q.a(jSONObject, "mSlowLooper", this.mSlowLooper);
        q.a(jSONObject, "mSlowOperation", this.mSlowOperation);
        q.a(jSONObject, "mBuildConfigInfo", this.mBuildConfigInfo);
        q.a(jSONObject, "mAbi", this.mAbi);
        return jSONObject;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("\u5f02\u5e38\u72b6\u6001\u6c47\u603b:\n").append("UUID: ").append(this.mLogUUID).append("\n").append("CPU\u67b6\u6784: ").append(this.mAbi).append("\n").append("\u5f02\u5e38\u8fdb\u7a0b: ").append(this.mProcessName).append(" (").append(this.mPid).append(")").append("\n").append("\u5f02\u5e38\u7ebf\u7a0b: ").append(this.mThreadName).append(" (").append(this.mTid).append(")").append("\n").append("\u5f02\u5e38\u7c7b\u578b: ").append(this.mCrashType).append("\n").append("\u5e94\u7528\u591a\u5f00\u73af\u5883: ").append(this.mVirtualApp).append("\n").append("TaskId: ").append(this.mTaskId).append("\n").append("mTid: ").append(this.mTid).append("\n").append("\u81ea\u5b9a\u4e49\u4fe1\u606f: ").append(this.mCustomMsg).append("\n").append("\u524d\u540e\u53f0\u72b6\u6001: ").append(this.mIsAppOnForeground).append("\n").append("\u5f02\u5e38\u53d1\u751f\u65f6\u95f4: ").append(i.a(this.mCurrentTimeStamp)).append("\n").append("\u7248\u672c\u53f7: ").append(this.mVersionCode).append("\n").append("\u5347\u7ea7\u524d\u7248\u672c\u53f7: ").append(this.mAppVersionBeforeLastUpload).append("\n").append("\u4f7f\u7528\u65f6\u957f: ").append(j.a(this.mUsageTimeMills)).append("\n").append("\u5f02\u5e38\u8be6\u60c5: \n");
            if (this instanceof JavaExceptionMessage) {
                stringBuilder.append(this.mCrashDetail.replace("##", "\n\t").replace("#", "\n"));
            } else {
                stringBuilder.append(this.mCrashDetail);
            }
            stringBuilder.append("\n").append("\u78c1\u76d8\u8be6\u60c5: \n").append(this.mDiskInfo).append("\n");
            if (!TextUtils.isEmpty((CharSequence)this.mErrorMessage)) {
                stringBuilder.append("\u5f02\u5e38\u4e0a\u62a5Debug: \n").append(this.mErrorMessage).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mBuildConfigInfo)) {
                stringBuilder.append("BuildConfig\u4fe1\u606f: \n").append(this.mBuildConfigInfo).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mJNIError)) {
                stringBuilder.append("JNI\u5f02\u5e38: \n").append(this.mJNIError).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mGCInfo)) {
                stringBuilder.append("GC\u8017\u65f6: \n").append(this.mGCInfo).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mLockInfo)) {
                stringBuilder.append("\u9501\u8017\u65f6(dvm_lock_sample): \n").append(this.mLockInfo).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mMonitorInfo)) {
                stringBuilder.append("\u9501\u8017\u65f6(monitor): \n").append(this.mMonitorInfo).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mSlowLooper)) {
                stringBuilder.append("Looper\u8017\u65f6: \n").append(this.mSlowLooper).append("\n");
            }
            if (!TextUtils.isEmpty((CharSequence)this.mSlowOperation)) {
                stringBuilder.append("AMS\u8c03\u5ea6\u8017\u65f6: \n").append(this.mSlowOperation).append("\n");
            }
            stringBuilder.append("\u5185\u5b58\u8be6\u60c5: \n").append(this.mMemoryInfo).append("\n");
        }
        catch (Throwable throwable) {
            a.b(throwable);
        }
        return stringBuilder.substring(0);
    }
}

