/*
 * Decompiled with CFR 0.152.
 */
package com.kwad.sdk.feed;

import android.support.annotation.NonNull;
import com.kwad.sdk.core.response.b.a;
import com.kwad.sdk.core.response.b.c;
import com.kwad.sdk.core.response.model.AdTemplate;

public enum FeedType {
    FEED_TYPE_UNKNOWN(0),
    FEED_TYPE_TEXT_IMMERSE(1),
    FEED_TYPE_TEXT_LEFT(2),
    FEED_TYPE_TEXT_RIGHT(3),
    FEED_TYPE_TEXT_ABOVE(4),
    FEED_TYPE_TEXT_BELOW(5),
    FEED_TYPE_TEXT_ABOVE_GROUP(6),
    FEED_TYPE_TEXT_NEW(7);

    private int type;

    private FeedType(int n3) {
        this.type = n3;
    }

    public int getType() {
        return this.type;
    }

    @NonNull
    public static FeedType fromInt(int n2) {
        for (FeedType feedType : FeedType.values()) {
            if (feedType.type != n2) continue;
            return feedType;
        }
        if (n2 >= FEED_TYPE_TEXT_NEW.getType()) {
            return FEED_TYPE_TEXT_NEW;
        }
        return FEED_TYPE_UNKNOWN;
    }

    public static boolean checkTypeValid(@NonNull AdTemplate adTemplate) {
        int n2 = a.H(c.h(adTemplate));
        if (adTemplate.type > FeedType.FEED_TYPE_TEXT_ABOVE_GROUP.type) {
            return true;
        }
        FeedType feedType = FeedType.fromInt(adTemplate.type);
        switch (n2) {
            case 2: {
                return feedType != FEED_TYPE_UNKNOWN && feedType != FEED_TYPE_TEXT_ABOVE_GROUP;
            }
            case 3: {
                return feedType != FEED_TYPE_UNKNOWN;
            }
            case 1: {
                return feedType == FEED_TYPE_TEXT_ABOVE || feedType == FEED_TYPE_TEXT_BELOW;
            }
        }
        return false;
    }
}

